<?php
session_start();

// Configuración de la base de datos (reemplaza con tus credenciales)
$db_host = 'localhost';
$db_user = 'stakpuna_jcvipuser';
$db_pass = 'JpbxnEHswszo';
$db_name = 'stakpuna_jcvip';

try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Error de conexión: " . $e->getMessage());
}

// Función para obtener datos de usuario (para el modal de edición)
function getUsuario($id) {
    global $conn;
    $stmt = $conn->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

// Procesar login del admin
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login_admin'])) {
    $correo = trim($_POST['correo']);
    $password = $_POST['password'];
    
    if ($correo === 'quotexgamer98@gmail.com') {
        $stmt = $conn->prepare("SELECT * FROM usuarios WHERE correo = ?");
        $stmt->execute([$correo]);
        $admin = $stmt->fetch();
        
        if ($admin && password_verify($password, $admin['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_correo'] = $admin['correo'];
            $_SESSION['admin_nombre'] = $admin['nombre_completo'];
            $_SESSION['admin_foto'] = $admin['foto_perfil'];
            header("Location: adminG.php");
            exit();
        } else {
            $login_error = 'Credenciales incorrectas';
        }
    } else {
        $login_error = 'Acceso restringido';
    }
}

// Procesar logout
if (isset($_POST['logout'])) {
    session_destroy();
    header("Location: adminG.php");
    exit();
}

// Verificar si el admin está logueado
$admin_logged_in = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;

// Si no está logueado, mostrar formulario de login
if (!$admin_logged_in) {
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>JC Investment - Admin Login</title>
        <style>
            :root {
                --primary: #00ff9d;
                --secondary: #00b8ff;
                --dark: #121212;
                --light: #f0f0f0;
                --danger: #ff3860;
            }
            
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
            
            body {
                background-color: var(--dark);
                color: var(--light);
                display: flex;
                justify-content: center;
                align-items: center;
                min-height: 100vh;
            }
            
            .login-container {
                background-color: rgba(18, 18, 18, 0.8);
                border: 1px solid rgba(0, 255, 157, 0.2);
                border-radius: 10px;
                padding: 2rem;
                width: 100%;
                max-width: 400px;
                box-shadow: 0 0 20px rgba(0, 255, 157, 0.1);
            }
            
            .logo {
                text-align: center;
                margin-bottom: 2rem;
            }
            
            .logo h1 {
                font-size: 2rem;
                background: linear-gradient(90deg, var(--primary), var(--secondary));
                -webkit-background-clip: text;
                background-clip: text;
                color: transparent;
                text-transform: uppercase;
                letter-spacing: 2px;
            }
            
            .form-group {
                margin-bottom: 1.5rem;
            }
            
            .form-group label {
                display: block;
                margin-bottom: 0.5rem;
                color: var(--light);
            }
            
            .form-group input {
                width: 100%;
                padding: 0.8rem;
                background-color: rgba(255, 255, 255, 0.05);
                border: 1px solid rgba(0, 255, 157, 0.3);
                border-radius: 5px;
                color: var(--light);
            }
            
            .btn {
                width: 100%;
                padding: 0.8rem;
                background: linear-gradient(90deg, var(--primary), var(--secondary));
                border: none;
                border-radius: 5px;
                color: var(--dark);
                font-weight: bold;
                cursor: pointer;
            }
            
            .error {
                color: var(--danger);
                text-align: center;
                margin-bottom: 1rem;
                padding: 0.8rem;
                background-color: rgba(255, 56, 96, 0.1);
                border-radius: 5px;
            }
        </style>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    </head>
    <body>
        <div class="login-container">
            <div class="logo">
                <h1>JC Investment</h1>
                <p>Panel de Administración</p>
            </div>
            
            <?php if (isset($login_error)): ?>
                <div class="error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $login_error; ?>
                </div>
            <?php endif; ?>
            
            <form action="adminG.php" method="POST">
                <div class="form-group">
                    <label for="correo">Correo Electrónico</label>
                    <input type="email" id="correo" name="correo" required>
                </div>
                
                <div class="form-group">
                    <label for="password">Contraseña</label>
                    <input type="password" id="password" name="password" required>
                </div>
                
                <button type="submit" name="login_admin" class="btn">
                    <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                </button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit();
}

// ==============================================
// A PARTIR DE AQUÍ ES EL PANEL DE ADMINISTRACIÓN
// ==============================================

// Variables para mensajes
$error = '';
$success = '';

// Procesar actualización de usuario
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['actualizar_usuario'])) {
        $usuario_id = $_POST['usuario_id'];
        $nombre = $_POST['nombre'];
        $correo = $_POST['correo'];
        $telefono = $_POST['telefono'];
        $wallet = $_POST['wallet'];
        
        $stmt = $conn->prepare("UPDATE usuarios SET nombre_completo = ?, correo = ?, telefono = ?, wallet_usdt = ? WHERE id = ?");
        if ($stmt->execute([$nombre, $correo, $telefono, $wallet, $usuario_id])) {
            $success = 'Usuario actualizado correctamente';
        } else {
            $error = 'Error al actualizar usuario';
        }
    }
    // Procesar transferencia entre saldos
    elseif (isset($_POST['transferir_saldo'])) {
        $usuario_id = $_POST['usuario_id'];
        $monto = floatval($_POST['monto']);
        $tipo = $_POST['tipo_transferencia'];
        
        if ($monto <= 0) {
            $error = 'El monto debe ser mayor que cero';
        } else {
            $conn->beginTransaction();
            try {
                // Obtener saldos actuales
                $stmt = $conn->prepare("SELECT saldo_deposito, saldo_planes FROM usuarios WHERE id = ?");
                $stmt->execute([$usuario_id]);
                $saldos = $stmt->fetch();
                
                if ($tipo == 'deposito_a_planes') {
                    if ($saldos['saldo_deposito'] < $monto) {
                        throw new Exception('Saldo insuficiente en depósito');
                    }
                    // Actualizar saldos
                    $stmt = $conn->prepare("UPDATE usuarios SET saldo_deposito = saldo_deposito - ?, saldo_planes = saldo_planes + ? WHERE id = ?");
                    $stmt->execute([$monto, $monto, $usuario_id]);
                } else {
                    if ($saldos['saldo_planes'] < $monto) {
                        throw new Exception('Saldo insuficiente en planes');
                    }
                    // Actualizar saldos
                    $stmt = $conn->prepare("UPDATE usuarios SET saldo_planes = saldo_planes - ?, saldo_deposito = saldo_deposito + ? WHERE id = ?");
                    $stmt->execute([$monto, $monto, $usuario_id]);
                }
                
                // Registrar transferencia
                $tipo_transfer = ($tipo == 'deposito_a_planes') ? 'deposito_a_inversion' : 'inversion_a_deposito';
                $stmt = $conn->prepare("INSERT INTO transferencias (usuario_id, monto, tipo) VALUES (?, ?, ?)");
                $stmt->execute([$usuario_id, $monto, $tipo_transfer]);
                
                $conn->commit();
                $success = 'Transferencia realizada correctamente';
            } catch (Exception $e) {
                $conn->rollBack();
                $error = $e->getMessage();
            }
        }
    }
    // Procesar aprobación de depósito
    elseif (isset($_POST['aprobar_deposito'])) {
        $deposito_id = $_POST['deposito_id'];
        
        $conn->beginTransaction();
        try {
            // Obtener información del depósito
            $stmt = $conn->prepare("SELECT * FROM depositos WHERE id = ?");
            $stmt->execute([$deposito_id]);
            $deposito = $stmt->fetch();
            
            if (!$deposito || $deposito['estado'] != 'pendiente') {
                throw new Exception('Depósito no válido o ya procesado');
            }
            
            // Actualizar estado del depósito
            $stmt = $conn->prepare("UPDATE depositos SET estado = 'completado' WHERE id = ?");
            $stmt->execute([$deposito_id]);
            
            // Añadir saldo al usuario
            $stmt = $conn->prepare("UPDATE usuarios SET saldo_deposito = saldo_deposito + ? WHERE id = ?");
            $stmt->execute([$deposito['monto'], $deposito['usuario_id']]);
            
            // Verificar si el usuario fue referido por alguien
            $stmt = $conn->prepare("SELECT referido_por FROM usuarios WHERE id = ?");
            $stmt->execute([$deposito['usuario_id']]);
            $usuario = $stmt->fetch();
            
            if ($usuario && $usuario['referido_por']) {
                // Calcular comisión (10%)
                $comision = $deposito['monto'] * 0.10;
                
                // Añadir comisión al referidor
                $stmt = $conn->prepare("UPDATE usuarios SET saldo_deposito = saldo_deposito + ? WHERE id = ?");
                $stmt->execute([$comision, $usuario['referido_por']]);
                
                // Registrar la transacción de referido
                $stmt = $conn->prepare("INSERT INTO referidos (usuario_referidor_id, usuario_referido_id, monto_deposito, comision) VALUES (?, ?, ?, ?)");
                $stmt->execute([$usuario['referido_por'], $deposito['usuario_id'], $deposito['monto'], $comision]);
            }
            
            $conn->commit();
            $success = 'Depósito aprobado y comisiones aplicadas correctamente';
        } catch (Exception $e) {
            $conn->rollBack();
            $error = $e->getMessage();
        }
    }
    // Procesar rechazo de depósito
    elseif (isset($_POST['rechazar_deposito'])) {
        $deposito_id = $_POST['deposito_id'];
        
        $stmt = $conn->prepare("UPDATE depositos SET estado = 'rechazado' WHERE id = ?");
        if ($stmt->execute([$deposito_id])) {
            $success = 'Depósito rechazado correctamente';
        } else {
            $error = 'Error al rechazar depósito';
        }
    }
    // Procesar adición manual de saldo
    elseif (isset($_POST['agregar_saldo'])) {
        $usuario_id = $_POST['usuario_id'];
        $monto = floatval($_POST['monto']);
        $tipo = $_POST['tipo_saldo'];
        
        if ($monto <= 0) {
            $error = 'El monto debe ser mayor que cero';
        } else {
            $campo = '';
            switch ($tipo) {
                case 'deposito': $campo = 'saldo_deposito'; break;
                case 'inversion': $campo = 'saldo_inversion'; break;
                case 'planes': $campo = 'saldo_planes'; break;
            }
            
            $stmt = $conn->prepare("UPDATE usuarios SET $campo = $campo + ? WHERE id = ?");
            if ($stmt->execute([$monto, $usuario_id])) {
                $success = "Saldo agregado correctamente al $tipo del usuario";
            } else {
                $error = 'Error al agregar saldo';
            }
        }
    }
    // Procesar actualización de retiro
    elseif (isset($_POST['actualizar_retiro'])) {
        $retiro_id = $_POST['retiro_id'];
        $estado = $_POST['estado'];
        
        $stmt = $conn->prepare("UPDATE retiros SET estado = ? WHERE id = ?");
        if ($stmt->execute([$estado, $retiro_id])) {
            $success = 'Estado de retiro actualizado correctamente';
        } else {
            $error = 'Error al actualizar estado de retiro';
        }
    }
    // Eliminar plan
    elseif (isset($_POST['eliminar_plan'])) {
        $plan_id = $_POST['plan_id'];
        
        $stmt = $conn->prepare("DELETE FROM planes WHERE id = ?");
        if ($stmt->execute([$plan_id])) {
            $success = 'Plan eliminado correctamente';
        } else {
            $error = 'Error al eliminar plan';
        }
    }
}

// Obtener todos los usuarios
$stmt = $conn->prepare("SELECT * FROM usuarios ORDER BY fecha_registro DESC");
$stmt->execute();
$usuarios = $stmt->fetchAll();

// Obtener planes de inversión
$stmt = $conn->prepare("SELECT p.*, u.nombre_completo FROM planes p JOIN usuarios u ON p.usuario_id = u.id ORDER BY p.fecha_inicio DESC");
$stmt->execute();
$planes = $stmt->fetchAll();

// Obtener depósitos pendientes
$stmt = $conn->prepare("SELECT d.*, u.nombre_completo FROM depositos d JOIN usuarios u ON d.usuario_id = u.id WHERE d.estado = 'pendiente' ORDER BY d.fecha DESC");
$stmt->execute();
$depositos = $stmt->fetchAll();

// Obtener retiros
$stmt = $conn->prepare("SELECT r.*, u.nombre_completo, u.wallet_usdt FROM retiros r JOIN usuarios u ON r.usuario_id = u.id ORDER BY r.fecha DESC");
$stmt->execute();
$retiros = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JC Investment - Panel de Administración</title>
    <style>
        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
        }
        
        .admin-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            margin-right: 1rem;
            overflow: hidden;
        }
        
        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 56, 96, 0.2);
        }
        
        .section {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1.5rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 1.5rem;
        }
        
        th {
            text-align: left;
            padding: 0.8rem;
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        td {
            padding: 0.8rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-avatar-small {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .form-group {
            margin-bottom: 1rem;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--light);
        }
        
        .form-group input, .form-group select {
            width: 100%;
            padding: 0.5rem;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 5px;
            color: var(--light);
        }
        
        .btn {
            padding: 0.5rem 1rem;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: bold;
        }
        
        .btn-primary {
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            color: var(--dark);
        }
        
        .btn-danger {
            background-color: var(--danger);
            color: white;
        }
        
        .btn-success {
            background-color: var(--success);
            color: white;
        }
        
        .btn-warning {
            background-color: var(--warning);
            color: var(--dark);
        }
        
        .btn-sm {
            padding: 0.3rem 0.6rem;
            font-size: 0.8rem;
        }
        
        .error {
            color: var(--danger);
            margin-bottom: 1rem;
            padding: 0.8rem;
            background-color: rgba(255, 56, 96, 0.1);
            border-radius: 5px;
        }
        
        .success {
            color: var(--success);
            margin-bottom: 1rem;
            padding: 0.8rem;
            background-color: rgba(0, 209, 178, 0.1);
            border-radius: 5px;
        }
        
        .status-pendiente {
            color: var(--warning);
        }
        
        .status-completado {
            color: var(--success);
        }
        
        .status-rechazado {
            color: var(--danger);
        }
        
        .tab-container {
            margin-bottom: 2rem;
        }
        
        .tabs {
            display: flex;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .tab {
            padding: 0.8rem 1.5rem;
            cursor: pointer;
            border-bottom: 3px solid transparent;
            transition: all 0.3s ease;
        }
        
        .tab.active {
            border-bottom-color: var(--primary);
            color: var(--primary);
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .amount {
            font-weight: bold;
        }
        
        .amount-positive {
            color: var(--success);
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <div class="header">
            <div class="user-info">
                <div class="user-avatar">
                    <img src="<?php echo htmlspecialchars($_SESSION['admin_foto']); ?>" alt="Foto de perfil">
                </div>
                <div class="user-name">Panel de Administración</div>
            </div>
            <form method="POST" action="adminG.php" style="display: inline;">
                <button type="submit" name="logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
                </button>
            </form>
        </div>
        
        <?php if ($error): ?>
            <div class="error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <div class="tab-container">
            <div class="tabs">
                <div class="tab active" data-tab="usuarios">Usuarios</div>
                <div class="tab" data-tab="planes">Planes</div>
                <div class="tab" data-tab="depositos">Depósitos</div>
                <div class="tab" data-tab="retiros">Retiros</div>
            </div>
            
            <!-- Tabla de Usuarios -->
            <div id="usuarios" class="tab-content active">
                <div class="section">
                    <h3 class="section-title"><i class="fas fa-users"></i> Lista de Usuarios</h3>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>Foto</th>
                                <th>Nombre</th>
                                <th>Correo</th>
                                <th>Teléfono</th>
                                <th>Wallet</th>
                                <th>Saldo Depósito</th>
                                <th>Saldo Planes</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($usuarios as $usuario): ?>
                            <tr>
                                <td><img src="<?php echo htmlspecialchars($usuario['foto_perfil']); ?>" class="user-avatar-small" alt="Foto"></td>
                                <td><?php echo htmlspecialchars($usuario['nombre_completo']); ?></td>
                                <td><?php echo htmlspecialchars($usuario['correo']); ?></td>
                                <td><?php echo htmlspecialchars($usuario['telefono']); ?></td>
                                <td><?php echo htmlspecialchars($usuario['wallet_usdt']); ?></td>
                                <td class="amount amount-positive">$<?php echo number_format($usuario['saldo_deposito'], 2); ?></td>
                                <td class="amount amount-positive">$<?php echo number_format($usuario['saldo_planes'], 2); ?></td>
                                <td>
                                    <button class="btn btn-primary btn-sm" onclick="mostrarEditarUsuario(<?php echo $usuario['id']; ?>, '<?php echo htmlspecialchars($usuario['nombre_completo'], ENT_QUOTES); ?>', '<?php echo htmlspecialchars($usuario['correo'], ENT_QUOTES); ?>', '<?php echo htmlspecialchars($usuario['telefono'], ENT_QUOTES); ?>', '<?php echo htmlspecialchars($usuario['wallet_usdt'], ENT_QUOTES); ?>')">
                                        <i class="fas fa-edit"></i> Editar
                                    </button>
                                    <button class="btn btn-success btn-sm" onclick="mostrarTransferirSaldo(<?php echo $usuario['id']; ?>)">
                                        <i class="fas fa-exchange-alt"></i> Transferir
                                    </button>
                                    <button class="btn btn-warning btn-sm" onclick="mostrarAgregarSaldo(<?php echo $usuario['id']; ?>)">
                                        <i class="fas fa-plus"></i> Agregar
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Tabla de Planes -->
            <div id="planes" class="tab-content">
                <div class="section">
                    <h3 class="section-title"><i class="fas fa-chart-line"></i> Planes de Inversión</h3>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>Usuario</th>
                                <th>Monto Inicial</th>
                                <th>Monto Actual</th>
                                <th>Ganancia</th>
                                <th>% Completado</th>
                                <th>Fecha Inicio</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($planes as $plan): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($plan['nombre_completo']); ?></td>
                                <td class="amount amount-positive">$<?php echo number_format($plan['monto_inicial'], 2); ?></td>
                                <td class="amount amount-positive">$<?php echo number_format($plan['monto_actual'], 2); ?></td>
                                <td class="amount amount-positive">$<?php echo number_format($plan['ganancia_acumulada'], 2); ?></td>
                                <td><?php echo number_format($plan['porcentaje_completado'], 2); ?>%</td>
                                <td><?php echo date('d/m/Y', strtotime($plan['fecha_inicio'])); ?></td>
                                <td><?php echo $plan['completado'] ? 'Completado' : 'Activo'; ?></td>
                                <td>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="plan_id" value="<?php echo $plan['id']; ?>">
                                        <button type="submit" name="eliminar_plan" class="btn btn-danger btn-sm">
                                            <i class="fas fa-trash"></i> Eliminar
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Tabla de Depósitos -->
            <div id="depositos" class="tab-content">
                <div class="section">
                    <h3 class="section-title"><i class="fas fa-wallet"></i> Depósitos Pendientes</h3>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>Usuario</th>
                                <th>Monto</th>
                                <th>Hash</th>
                                <th>Fecha</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($depositos as $deposito): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($deposito['nombre_completo']); ?></td>
                                <td class="amount amount-positive">$<?php echo number_format($deposito['monto'], 2); ?></td>
                                <td><?php echo htmlspecialchars($deposito['hash_transaccion']); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($deposito['fecha'])); ?></td>
                                <td>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="deposito_id" value="<?php echo $deposito['id']; ?>">
                                        <button type="submit" name="aprobar_deposito" class="btn btn-success btn-sm">
                                            <i class="fas fa-check"></i> Aprobar
                                        </button>
                                        <button type="submit" name="rechazar_deposito" class="btn btn-danger btn-sm">
                                            <i class="fas fa-times"></i> Rechazar
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Tabla de Retiros -->
            <div id="retiros" class="tab-content">
                <div class="section">
                    <h3 class="section-title"><i class="fas fa-money-bill-wave"></i> Solicitudes de Retiro</h3>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>Usuario</th>
                                <th>Wallet</th>
                                <th>Monto</th>
                                <th>Fecha</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($retiros as $retiro): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($retiro['nombre_completo']); ?></td>
                                <td><?php echo htmlspecialchars($retiro['wallet_usdt']); ?></td>
                                <td class="amount amount-positive">$<?php echo number_format($retiro['monto'], 2); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($retiro['fecha'])); ?></td>
                                <td class="status-<?php echo $retiro['estado']; ?>">
                                    <?php echo ucfirst($retiro['estado']); ?>
                                </td>
                                <td>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="retiro_id" value="<?php echo $retiro['id']; ?>">
                                        <select name="estado" class="btn-sm" style="padding: 0.3rem; margin-right: 0.5rem;">
                                            <option value="pendiente" <?php echo $retiro['estado'] == 'pendiente' ? 'selected' : ''; ?>>Pendiente</option>
                                            <option value="completado" <?php echo $retiro['estado'] == 'completado' ? 'selected' : ''; ?>>Completado</option>
                                            <option value="rechazado" <?php echo $retiro['estado'] == 'rechazado' ? 'selected' : ''; ?>>Rechazado</option>
                                        </select>
                                        <button type="submit" name="actualizar_retiro" class="btn btn-primary btn-sm">
                                            <i class="fas fa-save"></i> Actualizar
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal Editar Usuario -->
    <div id="modal-editar-usuario" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.8); z-index: 1000; justify-content: center; align-items: center;">
        <div style="background-color: var(--darker); padding: 2rem; border-radius: 10px; width: 500px; max-width: 90%;">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary);">Editar Usuario</h3>
            <form id="form-editar-usuario" method="POST">
                <input type="hidden" name="usuario_id" id="editar-usuario-id">
                
                <div class="form-group">
                    <label for="editar-nombre">Nombre Completo</label>
                    <input type="text" id="editar-nombre" name="nombre" required>
                </div>
                
                <div class="form-group">
                    <label for="editar-correo">Correo Electrónico</label>
                    <input type="email" id="editar-correo" name="correo" required>
                </div>
                
                <div class="form-group">
                    <label for="editar-telefono">Teléfono</label>
                    <input type="tel" id="editar-telefono" name="telefono" required>
                </div>
                
                <div class="form-group">
                    <label for="editar-wallet">Wallet USDT (BEP20)</label>
                    <input type="text" id="editar-wallet" name="wallet" required>
                </div>
                
                <div style="display: flex; justify-content: flex-end; margin-top: 1.5rem;">
                    <button type="button" onclick="cerrarModal('modal-editar-usuario')" class="btn btn-danger" style="margin-right: 1rem;">
                        <i class="fas fa-times"></i> Cancelar
                    </button>
                    <button type="submit" name="actualizar_usuario" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar Cambios
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modal Transferir Saldo -->
    <div id="modal-transferir-saldo" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.8); z-index: 1000; justify-content: center; align-items: center;">
        <div style="background-color: var(--darker); padding: 2rem; border-radius: 10px; width: 500px; max-width: 90%;">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary);">Transferir Saldo</h3>
            <form id="form-transferir-saldo" method="POST">
                <input type="hidden" name="usuario_id" id="transferir-usuario-id">
                
                <div class="form-group">
                    <label for="transferir-monto">Monto</label>
                    <input type="number" id="transferir-monto" name="monto" step="0.01" min="0.01" required>
                </div>
                
                <div class="form-group">
                    <label for="transferir-tipo">Tipo de Transferencia</label>
                    <select id="transferir-tipo" name="tipo_transferencia" required>
                        <option value="deposito_a_planes">De Depósito a Planes</option>
                        <option value="planes_a_deposito">De Planes a Depósito</option>
                    </select>
                </div>
                
                <div style="display: flex; justify-content: flex-end; margin-top: 1.5rem;">
                    <button type="button" onclick="cerrarModal('modal-transferir-saldo')" class="btn btn-danger" style="margin-right: 1rem;">
                        <i class="fas fa-times"></i> Cancelar
                    </button>
                    <button type="submit" name="transferir_saldo" class="btn btn-primary">
                        <i class="fas fa-exchange-alt"></i> Transferir
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modal Agregar Saldo -->
    <div id="modal-agregar-saldo" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.8); z-index: 1000; justify-content: center; align-items: center;">
        <div style="background-color: var(--darker); padding: 2rem; border-radius: 10px; width: 500px; max-width: 90%;">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary);">Agregar Saldo Manualmente</h3>
            <form id="form-agregar-saldo" method="POST">
                <input type="hidden" name="usuario_id" id="agregar-usuario-id">
                
                <div class="form-group">
                    <label for="agregar-monto">Monto</label>
                    <input type="number" id="agregar-monto" name="monto" step="0.01" min="0.01" required>
                </div>
                
                <div class="form-group">
                    <label for="agregar-tipo">Tipo de Saldo</label>
                    <select id="agregar-tipo" name="tipo_saldo" required>
                        <option value="deposito">Saldo Depósito</option>
                        <option value="inversion">Saldo Inversión</option>
                        <option value="planes">Saldo Planes</option>
                    </select>
                </div>
                
                <div style="display: flex; justify-content: flex-end; margin-top: 1.5rem;">
                    <button type="button" onclick="cerrarModal('modal-agregar-saldo')" class="btn btn-danger" style="margin-right: 1rem;">
                        <i class="fas fa-times"></i> Cancelar
                    </button>
                    <button type="submit" name="agregar_saldo" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Agregar
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <script>
        // Cambiar pestañas
        document.querySelectorAll('.tab').forEach(tab => {
            tab.addEventListener('click', function() {
                // Remover clase active de todas las pestañas y contenidos
                document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
                
                // Agregar clase active a la pestaña clickeada
                this.classList.add('active');
                
                // Mostrar el contenido correspondiente
                const tabId = this.getAttribute('data-tab');
                document.getElementById(tabId).classList.add('active');
            });
        });
        
        // Mostrar modal editar usuario
        function mostrarEditarUsuario(usuarioId, nombre, correo, telefono, wallet) {
            document.getElementById('editar-usuario-id').value = usuarioId;
            document.getElementById('editar-nombre').value = nombre;
            document.getElementById('editar-correo').value = correo;
            document.getElementById('editar-telefono').value = telefono;
            document.getElementById('editar-wallet').value = wallet;
            
            document.getElementById('modal-editar-usuario').style.display = 'flex';
        }
        
        // Mostrar modal transferir saldo
        function mostrarTransferirSaldo(usuarioId) {
            document.getElementById('transferir-usuario-id').value = usuarioId;
            document.getElementById('modal-transferir-saldo').style.display = 'flex';
        }
        
        // Mostrar modal agregar saldo
        function mostrarAgregarSaldo(usuarioId) {
            document.getElementById('agregar-usuario-id').value = usuarioId;
            document.getElementById('modal-agregar-saldo').style.display = 'flex';
        }
        
        // Cerrar modal
        function cerrarModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // Cerrar modales al hacer clic fuera del contenido
        document.querySelectorAll('[id^="modal-"]').forEach(modal => {
            modal.addEventListener('click', function(e) {
                if (e.target === this) {
                    this.style.display = 'none';
                }
            });
        });
    </script>
</body>
</html>