<?php
// Verificar estado de la sesión antes de iniciarla
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include 'connectAD.php';

// Verificar si el usuario está logueado como admin
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // Si no está logueado, mostrar formulario de login
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login'])) {
        $correo = $_POST['correo'];
        $password = $_POST['password'];
        
        // Verificar credenciales del admin
        $stmt = $conn->prepare("SELECT * FROM usuarios WHERE correo = ?");
        $stmt->execute([$correo]);
        $admin = $stmt->fetch();
        
        if ($admin && $correo === 'joelchaconvicente@gmail.com' && password_verify($password, $admin['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_email'] = $correo;
            header('Location: adminJC.php');
            exit();
        } else {
            $error = "Credenciales incorrectas o no tienes permisos de administrador";
        }
    }
    
    // Mostrar formulario de login
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin JC - Login</title>
        <style>
            :root {
                --primary: #00ff9d;
                --secondary: #00b8ff;
                --dark: #121212;
                --darker: #0a0a0a;
                --light: #f0f0f0;
                --danger: #ff3860;
                --success: #00d1b2;
            }
            
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
            
            body {
                background-color: var(--dark);
                color: var(--light);
                display: flex;
                justify-content: center;
                align-items: center;
                min-height: 100vh;
                padding: 2rem;
            }
            
            .login-container {
                background-color: rgba(10, 10, 10, 0.8);
                border: 1px solid rgba(0, 255, 157, 0.1);
                border-radius: 10px;
                padding: 2rem;
                width: 100%;
                max-width: 400px;
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
            }
            
            .login-title {
                text-align: center;
                margin-bottom: 1.5rem;
                color: var(--primary);
                font-size: 1.5rem;
            }
            
            .form-group {
                margin-bottom: 1.5rem;
            }
            
            .form-group label {
                display: block;
                margin-bottom: 0.5rem;
                color: var(--light);
            }
            
            .form-group input {
                width: 100%;
                padding: 0.8rem;
                background-color: rgba(255, 255, 255, 0.05);
                border: 1px solid rgba(0, 255, 157, 0.3);
                border-radius: 5px;
                color: var(--light);
                font-size: 1rem;
            }
            
            .btn {
                width: 100%;
                padding: 0.8rem;
                background: linear-gradient(90deg, var(--primary), var(--secondary));
                border: none;
                border-radius: 5px;
                color: var(--dark);
                font-weight: bold;
                cursor: pointer;
                transition: all 0.3s ease;
                font-size: 1rem;
            }
            
            .btn:hover {
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
            }
            
            .error {
                color: var(--danger);
                margin-bottom: 1rem;
                padding: 0.8rem;
                background-color: rgba(255, 56, 96, 0.1);
                border-radius: 5px;
                text-align: center;
            }
            
            .logo {
                text-align: center;
                margin-bottom: 1.5rem;
            }
            
            .logo h2 {
                font-size: 1.8rem;
                background: linear-gradient(90deg, var(--primary), var(--secondary));
                -webkit-background-clip: text;
                background-clip: text;
                color: transparent;
                text-transform: uppercase;
                letter-spacing: 2px;
            }
        </style>
    </head>
    <body>
        <div class="login-container">
            <div class="logo">
                <h2>JC Investment</h2>
            </div>
            <h2 class="login-title">Panel de Administración</h2>
            
            <?php if (isset($error)): ?>
                <div class="error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <form action="adminJC.php" method="POST">
                <div class="form-group">
                    <label for="correo">Correo Electrónico</label>
                    <input type="email" id="correo" name="correo" required>
                </div>
                
                <div class="form-group">
                    <label for="password">Contraseña</label>
                    <input type="password" id="password" name="password" required>
                </div>
                
                <button type="submit" name="login" class="btn">Iniciar Sesión</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit();
}

// Procesar logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: adminJC.php');
    exit();
}

// Procesar acciones del admin
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Transferir saldos entre cuentas
    if (isset($_POST['transferir'])) {
        $usuario_id = $_POST['usuario_id'];
        $monto = floatval($_POST['monto']);
        $de = $_POST['de'];
        $a = $_POST['a'];
        
        // Validar que no sea la misma cuenta
        if ($de === $a) {
            $_SESSION['admin_error'] = "No puedes transferir a la misma cuenta";
            header('Location: adminJC.php');
            exit();
        }
        
        // Validar monto positivo
        if ($monto <= 0) {
            $_SESSION['admin_error'] = "El monto debe ser mayor a 0";
            header('Location: adminJC.php');
            exit();
        }
        
        // Obtener saldos actuales del usuario
        $stmt = $conn->prepare("SELECT saldo_deposito, saldo_planes FROM usuarios WHERE id = ?");
        $stmt->execute([$usuario_id]);
        $usuario = $stmt->fetch();
        
        // Validar saldo suficiente
        if ($usuario[$de] < $monto) {
            $_SESSION['admin_error'] = "El usuario no tiene suficiente saldo en la cuenta de origen";
            header('Location: adminJC.php');
            exit();
        }
        
        // Realizar la transferencia
        try {
            $conn->beginTransaction();
            
            // Restar del origen
            $stmt = $conn->prepare("UPDATE usuarios SET $de = $de - ? WHERE id = ?");
            $stmt->execute([$monto, $usuario_id]);
            
            // Sumar al destino
            $stmt = $conn->prepare("UPDATE usuarios SET $a = $a + ? WHERE id = ?");
            $stmt->execute([$monto, $usuario_id]);
            
            $conn->commit();
            $_SESSION['admin_success'] = "Transferencia realizada correctamente";
        } catch (Exception $e) {
            $conn->rollBack();
            $_SESSION['admin_error'] = "Error al realizar la transferencia: " . $e->getMessage();
        }
        
        header('Location: adminJC.php');
        exit();
    }
    
    // Actualizar datos de usuario
    if (isset($_POST['actualizar_usuario'])) {
        $usuario_id = $_POST['usuario_id'];
        $nombre = $_POST['nombre'];
        $correo = $_POST['correo'];
        $telefono = $_POST['telefono'];
        
        try {
            $stmt = $conn->prepare("UPDATE usuarios SET nombre_completo = ?, correo = ?, telefono = ? WHERE id = ?");
            $stmt->execute([$nombre, $correo, $telefono, $usuario_id]);
            $_SESSION['admin_success'] = "Datos del usuario actualizados correctamente";
        } catch (Exception $e) {
            $_SESSION['admin_error'] = "Error al actualizar usuario: " . $e->getMessage();
        }
        
        header('Location: adminJC.php');
        exit();
    }
}

// Manejar solicitud AJAX para planes de usuario
if (isset($_GET['get_planes']) && isset($_GET['usuario_id'])) {
    $usuario_id = $_GET['usuario_id'];
    
    // Obtener planes del usuario
    $stmt = $conn->prepare("SELECT * FROM planes WHERE usuario_id = ? ORDER BY fecha_inicio DESC");
    $stmt->execute([$usuario_id]);
    $planes = $stmt->fetchAll();
    
    if (empty($planes)) {
        echo "<p>El usuario no tiene planes activos.</p>";
        exit();
    }
    
    echo '<table class="planes-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Tipo</th>
                <th>Monto Inicial</th>
                <th>Monto Actual</th>
                <th>Ganancia</th>
                <th>Progreso</th>
                <th>Estado</th>
                <th>Inicio</th>
            </tr>
        </thead>
        <tbody>';
    
    foreach ($planes as $plan) {
        echo '<tr>
            <td>'.$plan['id'].'</td>
            <td>
                <span class="badge '.($plan['es_reinversion'] ? 'badge-warning' : 'badge-primary').'">
                    '.($plan['es_reinversion'] ? 'Reinversión' : 'Inversión').'
                </span>
            </td>
            <td>$'.number_format($plan['monto_inicial'], 2).'</td>
            <td>$'.number_format($plan['monto_actual'], 2).'</td>
            <td>$'.number_format($plan['ganancia_acumulada'], 2).'</td>
            <td>'.number_format($plan['porcentaje_completado'], 2).'%</td>
            <td>
                <span class="badge '.($plan['completado'] ? 'badge-success' : 'badge-primary').'">
                    '.($plan['completado'] ? 'Completado' : 'Activo').'
                </span>
            </td>
            <td>'.date('d/m/Y', strtotime($plan['fecha_inicio'])).'</td>
        </tr>';
    }
    
    echo '</tbody></table>';
    exit();
}

// Obtener todos los usuarios
$stmt = $conn->prepare("SELECT * FROM usuarios ORDER BY fecha_registro DESC");
$stmt->execute();
$usuarios = $stmt->fetchAll();

// Obtener planes por usuario
$planes_por_usuario = [];
foreach ($usuarios as $usuario) {
    $stmt = $conn->prepare("SELECT COUNT(*) as total_planes FROM planes WHERE usuario_id = ?");
    $stmt->execute([$usuario['id']]);
    $planes = $stmt->fetch();
    $planes_por_usuario[$usuario['id']] = $planes['total_planes'];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin JC - Panel de Control</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            overflow-x: hidden;
        }
        
        .admin-header {
            background-color: rgba(10, 10, 10, 0.9);
            padding: 1rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .admin-title {
            font-size: 1.5rem;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .admin-title i {
            font-size: 1.8rem;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 56, 96, 0.2);
        }
        
        .admin-container {
            padding: 2rem;
        }
        
        .section-title {
            font-size: 1.4rem;
            margin-bottom: 1.5rem;
            color: var(--primary);
            padding-bottom: 0.5rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.2);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .section-title i {
            font-size: 1.6rem;
        }
        
        .users-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .user-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            position: relative;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        
        .user-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 255, 157, 0.1);
            border-color: rgba(0, 255, 157, 0.3);
        }
        
        .user-header {
            display: flex;
            align-items: center;
            margin-bottom: 1rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .user-avatar {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            overflow: hidden;
            margin-right: 1rem;
            border: 3px solid var(--primary);
            box-shadow: 0 0 15px rgba(0, 255, 157, 0.3);
        }
        
        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .user-name {
            font-weight: bold;
            font-size: 1.2rem;
            margin-bottom: 5px;
        }
        
        .user-email {
            font-size: 0.9rem;
            color: var(--secondary);
        }
        
        .user-details {
            margin-bottom: 1rem;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.8rem;
            font-size: 0.95rem;
            padding: 8px 10px;
            border-radius: 5px;
            background-color: rgba(255, 255, 255, 0.05);
        }
        
        .detail-label {
            color: rgba(255, 255, 255, 0.7);
        }
        
        .detail-value {
            font-weight: bold;
        }
        
        .saldo-deposito {
            color: var(--primary);
        }
        
        .saldo-inversion {
            color: var(--secondary);
        }
        
        .saldo-planes {
            color: var(--success);
        }
        
        .user-actions {
            margin-top: 1.5rem;
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }
        
        .btn {
            padding: 0.6rem 1.2rem;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary), #00cc8d);
            color: var(--dark);
            font-weight: bold;
        }
        
        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
        }
        
        .btn-warning {
            background: linear-gradient(135deg, var(--warning), #ffd700);
            color: var(--dark);
            font-weight: bold;
        }
        
        .btn-warning:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(255, 221, 87, 0.3);
        }
        
        .btn-info {
            background: linear-gradient(135deg, var(--secondary), #0099cc);
            color: var(--light);
            font-weight: bold;
        }
        
        .btn-info:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 184, 255, 0.3);
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            background-color: var(--darker);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 10px;
            padding: 2rem;
            width: 90%;
            max-width: 600px;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 0 30px rgba(0, 255, 157, 0.2);
            position: relative;
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.2);
        }
        
        .modal-title {
            font-size: 1.5rem;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .close-modal {
            background: none;
            border: none;
            color: var(--light);
            font-size: 2rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .close-modal:hover {
            color: var(--primary);
            transform: rotate(90deg);
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.8rem;
            color: var(--light);
            font-size: 1rem;
        }
        
        .form-group input, .form-group select {
            width: 100%;
            padding: 1rem;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 8px;
            color: var(--light);
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-group input:focus, .form-group select:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 10px rgba(0, 255, 157, 0.3);
        }
        
        .form-actions {
            display: flex;
            justify-content: flex-end;
            margin-top: 2rem;
        }
        
        .btn-submit {
            background: linear-gradient(135deg, var(--success), #00b89c);
            color: var(--dark);
            font-weight: bold;
            padding: 1rem 2rem;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 1.1rem;
            transition: all 0.3s ease;
        }
        
        .btn-submit:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 209, 178, 0.4);
        }
        
        .error-message {
            color: var(--danger);
            margin-bottom: 1.5rem;
            padding: 1rem;
            background-color: rgba(255, 56, 96, 0.1);
            border-radius: 8px;
            text-align: center;
            border-left: 4px solid var(--danger);
        }
        
        .success-message {
            color: var(--success);
            margin-bottom: 1.5rem;
            padding: 1rem;
            background-color: rgba(0, 209, 178, 0.1);
            border-radius: 8px;
            text-align: center;
            border-left: 4px solid var(--success);
        }
        
        .planes-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1.5rem;
            border-radius: 10px;
            overflow: hidden;
        }
        
        .planes-table th, .planes-table td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .planes-table th {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: var(--dark);
            font-weight: bold;
        }
        
        .planes-table tr:nth-child(even) {
            background-color: rgba(255, 255, 255, 0.05);
        }
        
        .planes-table tr:hover {
            background-color: rgba(0, 255, 157, 0.1);
        }
        
        .badge {
            display: inline-block;
            padding: 0.4rem 0.8rem;
            border-radius: 50px;
            font-size: 0.85rem;
            font-weight: bold;
        }
        
        .badge-primary {
            background-color: rgba(0, 255, 157, 0.15);
            color: var(--primary);
        }
        
        .badge-success {
            background-color: rgba(0, 209, 178, 0.15);
            color: var(--success);
        }
        
        .badge-warning {
            background-color: rgba(255, 221, 87, 0.15);
            color: var(--warning);
        }
        
        .stats-summary {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            text-align: center;
        }
        
        .stat-value {
            font-size: 2.5rem;
            font-weight: bold;
            margin: 1rem 0;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
        }
        
        .stat-label {
            font-size: 1.1rem;
            color: rgba(255, 255, 255, 0.7);
        }
        
        .glow {
            animation: glow 2s infinite alternate;
        }
        
        @keyframes glow {
            from {
                box-shadow: 0 0 5px rgba(0, 255, 157, 0.5);
            }
            to {
                box-shadow: 0 0 20px rgba(0, 255, 157, 0.8);
            }
        }
    </style>
</head>
<body>
    <div class="admin-header">
        <div class="admin-title">
            <i class="fas fa-chart-line"></i>
            <span>Panel de Administración JC Investment</span>
        </div>
        <button class="logout-btn" onclick="window.location.href='adminJC.php?logout=1'">
            <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
        </button>
    </div>
    
    <div class="admin-container">
        <?php if (isset($_SESSION['admin_error'])): ?>
            <div class="error-message">
                <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['admin_error']; ?>
            </div>
            <?php unset($_SESSION['admin_error']); ?>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['admin_success'])): ?>
            <div class="success-message">
                <i class="fas fa-check-circle"></i> <?php echo $_SESSION['admin_success']; ?>
            </div>
            <?php unset($_SESSION['admin_success']); ?>
        <?php endif; ?>
        
        <div class="stats-summary">
            <div class="stat-card glow">
                <div class="stat-label">Total Usuarios</div>
                <div class="stat-value"><?php echo count($usuarios); ?></div>
                <div><i class="fas fa-users fa-2x"></i></div>
            </div>
            <div class="stat-card glow">
                <div class="stat-label">Total Planes</div>
                <div class="stat-value"><?php echo array_sum($planes_por_usuario); ?></div>
                <div><i class="fas fa-chart-pie fa-2x"></i></div>
            </div>
            <div class="stat-card glow">
                <div class="stat-label">Saldo Total</div>
                <div class="stat-value">$
                    <?php 
                        $total_saldo = 0;
                        foreach ($usuarios as $usuario) {
                            $total_saldo += $usuario['saldo_deposito'] + $usuario['saldo_inversion'] + $usuario['saldo_planes'];
                        }
                        echo number_format($total_saldo, 2); 
                    ?>
                </div>
                <div><i class="fas fa-wallet fa-2x"></i></div>
            </div>
        </div>
        
        <h2 class="section-title">
            <i class="fas fa-users"></i> Usuarios Registrados
        </h2>
        
        <div class="users-grid">
            <?php foreach ($usuarios as $usuario): ?>
                <div class="user-card">
                    <div class="user-header">
                        <div class="user-avatar">
                            <img src="<?php echo htmlspecialchars($usuario['foto_perfil']); ?>" alt="Foto de perfil">
                        </div>
                        <div>
                            <div class="user-name"><?php echo htmlspecialchars($usuario['nombre_completo']); ?></div>
                            <div class="user-email"><?php echo htmlspecialchars($usuario['correo']); ?></div>
                        </div>
                    </div>
                    
                    <div class="user-details">
                        <div class="detail-row">
                            <span class="detail-label">Teléfono:</span>
                            <span class="detail-value"><?php echo htmlspecialchars($usuario['telefono']); ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Wallet USDT:</span>
                            <span class="detail-value"><?php echo htmlspecialchars($usuario['wallet_usdt']); ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Registro:</span>
                            <span class="detail-value"><?php echo date('d/m/Y H:i', strtotime($usuario['fecha_registro'])); ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Planes:</span>
                            <span class="detail-value"><?php echo $planes_por_usuario[$usuario['id']]; ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Saldo Depósito:</span>
                            <span class="detail-value saldo-deposito">$<?php echo number_format($usuario['saldo_deposito'], 2); ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Saldo Inversión:</span>
                            <span class="detail-value saldo-inversion">$<?php echo number_format($usuario['saldo_inversion'], 2); ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Saldo Planes:</span>
                            <span class="detail-value saldo-planes">$<?php echo number_format($usuario['saldo_planes'], 2); ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Total Retirado:</span>
                            <span class="detail-value">$<?php echo number_format($usuario['total_retirado'], 2); ?></span>
                        </div>
                    </div>
                    
                    <div class="user-actions">
                        <button class="btn btn-primary" onclick="openEditModal(<?php echo $usuario['id']; ?>, '<?php echo htmlspecialchars($usuario['nombre_completo']); ?>', '<?php echo htmlspecialchars($usuario['correo']); ?>', '<?php echo htmlspecialchars($usuario['telefono']); ?>')">
                            <i class="fas fa-edit"></i> Editar
                        </button>
                        <button class="btn btn-warning" onclick="openTransferModal(<?php echo $usuario['id']; ?>, '<?php echo htmlspecialchars($usuario['nombre_completo']); ?>')">
                            <i class="fas fa-exchange-alt"></i> Transferir
                        </button>
                        <button class="btn btn-info" onclick="openPlanesModal(<?php echo $usuario['id']; ?>, '<?php echo htmlspecialchars($usuario['nombre_completo']); ?>')">
                            <i class="fas fa-chart-line"></i> Planes
                        </button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <!-- Modal para editar usuario -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-user-edit"></i> Editar Usuario</h3>
                <button class="close-modal" onclick="closeModal('editModal')">&times;</button>
            </div>
            <form id="editUserForm" method="POST" action="adminJC.php">
                <input type="hidden" name="usuario_id" id="editUsuarioId">
                
                <div class="form-group">
                    <label for="editNombre"><i class="fas fa-user"></i> Nombre Completo</label>
                    <input type="text" id="editNombre" name="nombre" required>
                </div>
                
                <div class="form-group">
                    <label for="editCorreo"><i class="fas fa-envelope"></i> Correo Electrónico</label>
                    <input type="email" id="editCorreo" name="correo" required>
                </div>
                
                <div class="form-group">
                    <label for="editTelefono"><i class="fas fa-phone"></i> Teléfono</label>
                    <input type="text" id="editTelefono" name="telefono" required>
                </div>
                
                <div class="form-actions">
                    <button type="submit" name="actualizar_usuario" class="btn-submit">
                        <i class="fas fa-save"></i> Guardar Cambios
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modal para transferir saldo -->
    <div id="transferModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-exchange-alt"></i> Transferir Saldo</h3>
                <button class="close-modal" onclick="closeModal('transferModal')">&times;</button>
            </div>
            <form id="transferForm" method="POST" action="adminJC.php">
                <input type="hidden" name="usuario_id" id="transferUsuarioId">
                
                <div class="form-group">
                    <label for="transferMonto"><i class="fas fa-money-bill-wave"></i> Monto a Transferir</label>
                    <input type="number" id="transferMonto" name="monto" min="0.01" step="0.01" required>
                </div>
                
                <div class="form-group">
                    <label for="transferDe"><i class="fas fa-arrow-circle-down"></i> De:</label>
                    <select id="transferDe" name="de" required>
                        <option value="saldo_deposito">Saldo Depósito</option>
                        <option value="saldo_planes">Saldo Planes</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="transferA"><i class="fas fa-arrow-circle-up"></i> A:</label>
                    <select id="transferA" name="a" required>
                        <option value="saldo_planes">Saldo Planes</option>
                        <option value="saldo_deposito">Saldo Depósito</option>
                    </select>
                </div>
                
                <div class="form-actions">
                    <button type="submit" name="transferir" class="btn-submit">
                        <i class="fas fa-exchange-alt"></i> Realizar Transferencia
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modal para ver planes -->
    <div id="planesModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-chart-line"></i> Planes del Usuario</h3>
                <button class="close-modal" onclick="closeModal('planesModal')">&times;</button>
            </div>
            <div id="planesContent">
                <!-- Contenido se cargará dinámicamente -->
            </div>
        </div>
    </div>
    
    <script>
        // Funciones para manejar modales
        function openEditModal(id, nombre, correo, telefono) {
            document.getElementById('editUsuarioId').value = id;
            document.getElementById('editNombre').value = nombre;
            document.getElementById('editCorreo').value = correo;
            document.getElementById('editTelefono').value = telefono;
            document.getElementById('editModal').style.display = 'flex';
        }
        
        function openTransferModal(id, nombre) {
            document.getElementById('transferUsuarioId').value = id;
            document.getElementById('transferModal').style.display = 'flex';
            // Resetear formulario
            document.getElementById('transferForm').reset();
            // Asegurarse de que los selects no sean iguales
            document.getElementById('transferDe').value = 'saldo_deposito';
            document.getElementById('transferA').value = 'saldo_planes';
        }
        
        function openPlanesModal(id, nombre) {
            // Mostrar mensaje de carga
            document.getElementById('planesContent').innerHTML = `
                <div style="text-align: center; padding: 2rem;">
                    <i class="fas fa-spinner fa-spin fa-3x" style="color: var(--primary); margin-bottom: 1rem;"></i>
                    <p>Cargando planes de ${nombre}...</p>
                </div>
            `;
            
            document.getElementById('planesModal').style.display = 'flex';
            
            // Cargar planes del usuario via AJAX
            fetch(`adminJC.php?get_planes=1&usuario_id=${id}`)
                .then(response => response.text())
                .then(data => {
                    document.getElementById('planesContent').innerHTML = `
                        <h4 style="margin-bottom: 1.5rem; color: var(--primary);">Planes de ${nombre}</h4>
                        ${data}
                    `;
                })
                .catch(error => {
                    document.getElementById('planesContent').innerHTML = `
                        <div class="error-message">
                            <i class="fas fa-exclamation-circle"></i> Error al cargar los planes: ${error}
                        </div>
                    `;
                });
        }
        
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // Cerrar modal al hacer clic fuera del contenido
        window.onclick = function(event) {
            if (event.target.className === 'modal') {
                event.target.style.display = 'none';
            }
        }
    </script>
</body>
</html>