-- Tabla de usuarios
CREATE TABLE usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre_completo VARCHAR(100) NOT NULL,
    correo VARCHAR(100) NOT NULL UNIQUE,
    telefono VARCHAR(20) NOT NULL,
    wallet_usdt VARCHAR(100) NOT NULL,
    password VARCHAR(255) NOT NULL,
    foto_perfil VARCHAR(255) DEFAULT 'default.png',
    saldo_deposito DECIMAL(15, 2) DEFAULT 0.00,
    saldo_inversion DECIMAL(15, 2) DEFAULT 0.00,
    saldo_planes DECIMAL(15, 2) DEFAULT 0.00,
    total_retirado DECIMAL(15, 2) DEFAULT 0.00,
    fecha_registro DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Tabla de planes de inversión
CREATE TABLE planes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT NOT NULL,
    monto_inicial DECIMAL(15, 2) NOT NULL,
    monto_actual DECIMAL(15, 2) NOT NULL,
    porcentaje_completado DECIMAL(5, 2) DEFAULT 0.00,
    es_reinversion BOOLEAN DEFAULT FALSE,
    fecha_inicio DATETIME DEFAULT CURRENT_TIMESTAMP,
    fecha_ultima_actualizacion DATETIME DEFAULT CURRENT_TIMESTAMP,
    completado BOOLEAN DEFAULT FALSE,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
);

-- Tabla de transacciones de depósito
CREATE TABLE depositos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT NOT NULL,
    monto DECIMAL(15, 2) NOT NULL,
    hash_transaccion VARCHAR(100) NOT NULL,
    estado ENUM('pendiente', 'completado', 'rechazado') DEFAULT 'pendiente',
    fecha DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
);

-- Tabla de retiros
CREATE TABLE retiros (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT NOT NULL,
    monto DECIMAL(15, 2) NOT NULL,
    estado ENUM('pendiente', 'completado', 'rechazado') DEFAULT 'pendiente',
    fecha DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
);

-- Tabla de transferencias internas
CREATE TABLE transferencias (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT NOT NULL,
    monto DECIMAL(15, 2) NOT NULL,
    tipo ENUM('deposito_a_inversion', 'inversion_a_deposito') NOT NULL,
    fecha DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
);