<?php
session_start();
include 'connect.php';

// Verificar permisos de administrador
if (!isset($_SESSION['admin_logged_in']) {
    die("Acceso no autorizado");
}

$usuario_id = $_GET['usuario_id'];

// Obtener planes del usuario
$stmt = $conn->prepare("SELECT * FROM planes WHERE usuario_id = ? ORDER BY fecha_inicio DESC");
$stmt->execute([$usuario_id]);
$planes = $stmt->fetchAll();

if (empty($planes)) {
    echo "<p>El usuario no tiene planes activos.</p>";
    exit();
}
?>

<table class="planes-table">
    <thead>
        <tr>
            <th>ID</th>
            <th>Tipo</th>
            <th>Monto Inicial</th>
            <th>Monto Actual</th>
            <th>Ganancia</th>
            <th>Progreso</th>
            <th>Estado</th>
            <th>Inicio</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($planes as $plan): ?>
            <tr>
                <td><?php echo $plan['id']; ?></td>
                <td>
                    <span class="badge <?php echo $plan['es_reinversion'] ? 'badge-warning' : 'badge-primary'; ?>">
                        <?php echo $plan['es_reinversion'] ? 'Reinversión' : 'Inversión'; ?>
                    </span>
                </td>
                <td>$<?php echo number_format($plan['monto_inicial'], 2); ?></td>
                <td>$<?php echo number_format($plan['monto_actual'], 2); ?></td>
                <td>$<?php echo number_format($plan['ganancia_acumulada'], 2); ?></td>
                <td><?php echo number_format($plan['porcentaje_completado'], 2); ?>%</td>
                <td>
                    <span class="badge <?php echo $plan['completado'] ? 'badge-success' : 'badge-primary'; ?>">
                        <?php echo $plan['completado'] ? 'Completado' : 'Activo'; ?>
                    </span>
                </td>
                <td><?php echo date('d/m/Y', strtotime($plan['fecha_inicio'])); ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>