<?php
include 'connect.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT nombre_completo, foto_perfil FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Obtener historial de depósitos
$stmt_depositos = $conn->prepare("SELECT * FROM depositos WHERE usuario_id = ? ORDER BY fecha DESC");
$stmt_depositos->execute([$user_id]);
$depositos = $stmt_depositos->fetchAll();

// Obtener historial de retiros
$stmt_retiros = $conn->prepare("SELECT * FROM retiros WHERE usuario_id = ? ORDER BY fecha DESC");
$stmt_retiros->execute([$user_id]);
$retiros = $stmt_retiros->fetchAll();

// Obtener historial de transferencias
$stmt_transferencias = $conn->prepare("SELECT * FROM transferencias WHERE usuario_id = ? ORDER BY fecha DESC");
$stmt_transferencias->execute([$user_id]);
$transferencias = $stmt_transferencias->fetchAll();

// Obtener historial de planes
$stmt_planes = $conn->prepare("SELECT * FROM planes WHERE usuario_id = ? ORDER BY fecha_inicio DESC");
$stmt_planes->execute([$user_id]);
$planes = $stmt_planes->fetchAll();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JC Investment - Historial</title>
    <style>
        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: rgba(10, 10, 10, 0.8);
            border-right: 1px solid rgba(0, 255, 157, 0.1);
            padding: 1.5rem;
            position: fixed;
            height: 100vh;
            z-index: 100;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 2rem;
        }
        
        /* Estilos reutilizados del dashboard */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        /* Estilos específicos de historial */
        .tabs {
            display: flex;
            margin-bottom: 1.5rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .tab {
            padding: 0.8rem 1.5rem;
            cursor: pointer;
            border-bottom: 3px solid transparent;
            transition: all 0.3s ease;
        }
        
        .tab.active {
            border-bottom-color: var(--primary);
            color: var(--primary);
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .history-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 2rem;
        }
        
        .history-table th {
            text-align: left;
            padding: 1rem;
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .history-table td {
            padding: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .history-table tr:last-child td {
            border-bottom: none;
        }
        
        .status {
            display: inline-block;
            padding: 0.3rem 0.6rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: bold;
        }
        
        .status-pendiente {
            background-color: rgba(255, 221, 87, 0.1);
            color: var(--warning);
        }
        
        .status-completado {
            background-color: rgba(0, 209, 178, 0.1);
            color: var(--success);
        }
        
        .status-rechazado {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
        }
        
        .amount {
            font-weight: bold;
        }
        
        .amount.positive {
            color: var(--success);
        }
        
        .amount.negative {
            color: var(--danger);
        }
        
        .no-records {
            text-align: center;
            padding: 2rem;
            color: rgba(255, 255, 255, 0.5);
        }
        
        .transfer-type {
            display: inline-block;
            padding: 0.3rem 0.6rem;
            border-radius: 20px;
            font-size: 0.8rem;
            background-color: rgba(0, 184, 255, 0.1);
            color: var(--secondary);
        }
        
        .plan-type {
            display: inline-block;
            padding: 0.3rem 0.6rem;
            border-radius: 20px;
            font-size: 0.8rem;
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .plan-type.reinvestment {
            background-color: rgba(0, 184, 255, 0.1);
            color: var(--secondary);
        }





        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: rgba(10, 10, 10, 0.8);
            border-right: 1px solid rgba(0, 255, 157, 0.1);
            padding: 1.5rem;
            position: fixed;
            height: 100vh;
            z-index: 100;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .logo h2 {
            font-size: 1.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .nav-menu {
            list-style: none;
        }
        
        .nav-item {
            margin-bottom: 0.5rem;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.8rem 1rem;
            color: var(--light);
            text-decoration: none;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover, .nav-link.active {
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .nav-link i {
            margin-right: 0.8rem;
            font-size: 1.2rem;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 2rem;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(0, 255, 157, 0.1);
            margin-right: 1rem;
            overflow: hidden;
        }
        
        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 56, 96, 0.2);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 255, 157, 0.1);
            border-color: rgba(0, 255, 157, 0.3);
        }
        
        .stat-title {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 0.5rem;
        }
        
        .stat-value {
            font-size: 1.8rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
        }
        
        .stat-desc {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.5);
        }
        
        .card-primary {
            border-top: 3px solid var(--primary);
        }
        
        .card-secondary {
            border-top: 3px solid var(--secondary);
        }
        
        .card-success {
            border-top: 3px solid var(--success);
        }
        
        .card-warning {
            border-top: 3px solid var(--warning);
        }
        
        .recent-activity {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            margin-top: 2rem;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        .activity-list {
            list-style: none;
        }
        
        .activity-item {
            padding: 1rem 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            display: flex;
            align-items: center;
        }
        
        .activity-item:last-child {
            border-bottom: none;
        }
        
        .activity-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(0, 255, 157, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            color: var(--primary);
        }
        
        .activity-content {
            flex: 1;
        }
        
        .activity-title {
            font-size: 0.9rem;
            margin-bottom: 0.2rem;
        }
        
        .activity-desc {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.6);
        }
        
        .activity-time {
            font-size: 0.7rem;
            color: rgba(255, 255, 255, 0.4);
        }
        
        /* Efectos futuristas */
        .glow-effect {
            position: relative;
            overflow: hidden;
        }
        
        .glow-effect::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0.3)
            );
            transform: rotate(30deg);
            animation: glow 6s linear infinite;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .glow-effect:hover::before {
            opacity: 0.3;
        }
        
        @keyframes glow {
            0% {
                transform: rotate(30deg) translate(-10%, -10%);
            }
            100% {
                transform: rotate(30deg) translate(10%, 10%);
            }
        }
        
        .no-activity {
            text-align: center;
            padding: 1rem;
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.9rem;
        }


















    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="sidebar">
        <div class="logo">
            <h2>JC Investment</h2>
        </div>
        
        <ul class="nav-menu">
            <li class="nav-item">
                <a href="dashboard.php" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="perfil.php" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Perfil</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="planes.php" class="nav-link">
                    <i class="fas fa-chart-line"></i>
                    <span>Planes</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="transferencia.php" class="nav-link">
                    <i class="fas fa-exchange-alt"></i>
                    <span>Transferencia</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="historial.php" class="nav-link active">
                    <i class="fas fa-history"></i>
                    <span>Historial</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="deposito.php" class="nav-link">
                    <i class="fas fa-wallet"></i>
                    <span>Depósito</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="retiro.php" class="nav-link">
                    <i class="fas fa-money-bill-wave"></i>
                    <span>Retiro</span>
                </a>
            </li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="header">
            <div class="user-info">
                <div class="user-avatar">
                    <img src="<?php echo isset($user['foto_perfil']) ? $user['foto_perfil'] : 'default.png'; ?>" alt="Foto de perfil">
                </div>
                <div class="user-name"><?php echo htmlspecialchars($user['nombre_completo']); ?></div>
            </div>
            <button class="logout-btn" onclick="window.location.href='logout.php'">
                <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
            </button>
        </div>
        
        <h2 class="section-title">
            <i class="fas fa-history"></i> Historial de Transacciones
        </h2>
        
        <div class="tabs">
            <div class="tab active" data-tab="depositos">Depósitos</div>
            <div class="tab" data-tab="retiros">Retiros</div>
            <div class="tab" data-tab="transferencias">Transferencias</div>
            <div class="tab" data-tab="planes">Planes</div>
        </div>
        
        <div id="depositos" class="tab-content active">
            <table class="history-table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Monto</th>
                        <th>Hash</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($depositos)): ?>
                        <tr>
                            <td colspan="4" class="no-records">No hay depósitos registrados</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($depositos as $deposito): ?>
                            <tr>
                                <td><?php echo date('d/m/Y H:i', strtotime($deposito['fecha'])); ?></td>
                                <td class="amount positive">+$<?php echo number_format($deposito['monto'], 2); ?></td>
                                <td><?php echo substr($deposito['hash_transaccion'], 0, 10) . '...'; ?></td>
                                <td>
                                    <span class="status status-<?php echo $deposito['estado']; ?>">
                                        <?php echo ucfirst($deposito['estado']); ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div id="retiros" class="tab-content">
            <table class="history-table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Monto</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($retiros)): ?>
                        <tr>
                            <td colspan="3" class="no-records">No hay retiros registrados</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($retiros as $retiro): ?>
                            <tr>
                                <td><?php echo date('d/m/Y H:i', strtotime($retiro['fecha'])); ?></td>
                                <td class="amount negative">-$<?php echo number_format($retiro['monto'], 2); ?></td>
                                <td>
                                    <span class="status status-<?php echo $retiro['estado']; ?>">
                                        <?php echo ucfirst($retiro['estado']); ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div id="transferencias" class="tab-content">
            <table class="history-table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Tipo</th>
                        <th>Monto</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($transferencias)): ?>
                        <tr>
                            <td colspan="3" class="no-records">No hay transferencias registradas</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($transferencias as $transferencia): ?>
                            <tr>
                                <td><?php echo date('d/m/Y H:i', strtotime($transferencia['fecha'])); ?></td>
                                <td>
                                    <?php if ($transferencia['tipo'] == 'deposito_a_inversion'): ?>
                                        <span class="transfer-type">Depósito → Inversión</span>
                                    <?php else: ?>
                                        <span class="transfer-type">Inversión → Depósito</span>
                                    <?php endif; ?>
                                </td>
                                <td class="amount">
                                    $<?php echo number_format($transferencia['monto'], 2); ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div id="planes" class="tab-content">
            <table class="history-table">
                <thead>
                    <tr>
                        <th>Fecha Inicio</th>
                        <th>Tipo</th>
                        <th>Inversión</th>
                        <th>Ganancia</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($planes)): ?>
                        <tr>
                            <td colspan="5" class="no-records">No hay planes registrados</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($planes as $plan): ?>
                            <tr>
                                <td><?php echo date('d/m/Y', strtotime($plan['fecha_inicio'])); ?></td>
                                <td>
                                    <?php if ($plan['es_reinversion']): ?>
                                        <span class="plan-type reinvestment">Reinversión</span>
                                    <?php else: ?>
                                        <span class="plan-type">Inversión</span>
                                    <?php endif; ?>
                                </td>
                                <td>$<?php echo number_format($plan['monto_inicial'], 2); ?></td>
                                <td class="amount positive">+$<?php echo number_format($plan['monto_actual'] - $plan['monto_inicial'], 2); ?></td>
                                <td>
                                    <?php if ($plan['completado']): ?>
                                        <span class="status status-completado">Completado</span>
                                    <?php else: ?>
                                        <span class="status status-pendiente">En progreso (<?php echo number_format($plan['porcentaje_completado'], 2); ?>%)</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        // Cambiar pestañas
        document.querySelectorAll('.tab').forEach(tab => {
            tab.addEventListener('click', function() {
                // Remover clase active de todas las pestañas y contenidos
                document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
                
                // Agregar clase active a la pestaña clickeada
                this.classList.add('active');
                
                // Mostrar el contenido correspondiente
                const tabId = this.getAttribute('data-tab');
                document.getElementById(tabId).classList.add('active');
            });
        });
    </script>
</body>
</html>