<?php
include 'connect.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Verificar si es el usuario referidor especial
$es_referidor = ($user['correo'] == 'joelchaconvicente@gmail.com');

// Obtener estadísticas de referidos si es el referidor
if ($es_referidor) {
    $stmt = $conn->prepare("SELECT COUNT(id) as total_referidos, SUM(comision) as total_comisiones FROM referidos WHERE usuario_referidor_id = ?");
    $stmt->execute([$user_id]);
    $stats = $stmt->fetch();
    
    $total_referidos = $stats['total_referidos'] ?? 0;
    $total_comisiones = $stats['total_comisiones'] ?? 0;
}

$error = '';
$success = '';

// Procesar actualización de perfil
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['actualizar_perfil'])) {
        $telefono = $_POST['telefono'];
        
        // Actualizar teléfono
        $stmt = $conn->prepare("UPDATE usuarios SET telefono = ? WHERE id = ?");
        $stmt->execute([$telefono, $user_id]);
        $success = 'Perfil actualizado correctamente';
        
        // Actualizar foto de perfil si se subió una
        if (isset($_FILES['foto_perfil']) && $_FILES['foto_perfil']['error'] == UPLOAD_ERR_OK) {
            $target_dir = "uploads/";
            if (!file_exists($target_dir)) {
                mkdir($target_dir, 0777, true);
            }
            
            $file_extension = pathinfo($_FILES['foto_perfil']['name'], PATHINFO_EXTENSION);
            $new_filename = 'user_' . $user_id . '_' . time() . '.' . $file_extension;
            $target_file = $target_dir . $new_filename;
            
            // Verificar si es una imagen real
            $check = getimagesize($_FILES['foto_perfil']['tmp_name']);
            if ($check !== false) {
                if (move_uploaded_file($_FILES['foto_perfil']['tmp_name'], $target_file)) {
                    // Actualizar en la base de datos
                    $stmt = $conn->prepare("UPDATE usuarios SET foto_perfil = ? WHERE id = ?");
                    $stmt->execute([$target_file, $user_id]);
                    $user['foto_perfil'] = $target_file;
                } else {
                    $error = 'Error al subir la imagen';
                }
            } else {
                $error = 'El archivo no es una imagen válida';
            }
        }
    } elseif (isset($_POST['cambiar_password'])) {
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];
        
        if (password_verify($current_password, $user['password'])) {
            if ($new_password === $confirm_password) {
                $hashed_password = password_hash($new_password, PASSWORD_BCRYPT);
                $stmt = $conn->prepare("UPDATE usuarios SET password = ? WHERE id = ?");
                $stmt->execute([$hashed_password, $user_id]);
                $success = 'Contraseña cambiada correctamente';
            } else {
                $error = 'Las contraseñas nuevas no coinciden';
            }
        } else {
            $error = 'La contraseña actual es incorrecta';
        }
    }
    
    // Refrescar datos del usuario
    $stmt = $conn->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JC Investment - Perfil</title>
    <style>
        /* Todos los estilos anteriores se mantienen igual */
        
        /* Nuevos estilos para la sección de referidos */
        .referidos-section {
            margin-top: 2rem;
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
        }
        
        .referidos-stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .referido-stat {
            background-color: rgba(0, 255, 157, 0.1);
            padding: 1rem;
            border-radius: 5px;
            text-align: center;
        }
        
        .referido-stat-value {
            font-size: 1.5rem;
            font-weight: bold;
            color: var(--primary);
            margin-bottom: 0.5rem;
        }
        
        .referido-stat-label {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
        }
        
        .referido-link-container {
            margin-bottom: 1.5rem;
        }
        
        .referido-link-input {
            display: flex;
            margin-bottom: 0.5rem;
        }
        
        .referido-link-input input {
            flex: 1;
            padding: 0.8rem;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 5px 0 0 5px;
            color: var(--light);
        }
        
        .referido-link-input button {
            padding: 0.8rem 1rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 0 5px 5px 0;
            color: var(--dark);
            font-weight: bold;
            cursor: pointer;
        }
        
        .referido-link-desc {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.6);
        }
        
        .referidos-list {
            margin-top: 1.5rem;
        }
        
        .referidos-list h4 {
            margin-bottom: 1rem;
            color: var(--primary);
        }
        
        .referidos-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .referidos-table th {
            text-align: left;
            padding: 0.8rem;
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .referidos-table td {
            padding: 0.8rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .referido-amount {
            color: var(--success);
            font-weight: bold;
        }
        
        .referido-comision {
            color: var(--primary);
            font-weight: bold;
        }




          :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: rgba(10, 10, 10, 0.8);
            border-right: 1px solid rgba(0, 255, 157, 0.1);
            padding: 1.5rem;
            position: fixed;
            height: 100vh;
            z-index: 100;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 2rem;
        }
        
        /* Estilos reutilizados del dashboard */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        /* Estilos específicos de perfil */
        .profile-container {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 2rem;
        }
        
        .profile-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            text-align: center;
        }
        
        .profile-avatar {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            margin: 0 auto 1rem;
            overflow: hidden;
            border: 3px solid var(--primary);
            position: relative;
        }
        
        .profile-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .profile-avatar-edit {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: rgba(0, 0, 0, 0.7);
            padding: 0.5rem;
            cursor: pointer;
        }
        
        .profile-avatar-edit:hover {
            background-color: rgba(0, 255, 157, 0.5);
        }
        
        .profile-name {
            font-size: 1.2rem;
            margin-bottom: 0.5rem;
            color: var(--primary);
        }
        
        .profile-email {
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 1rem;
        }
        
        .profile-stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-top: 1rem;
        }
        
        .stat-item {
            background-color: rgba(0, 255, 157, 0.1);
            padding: 0.5rem;
            border-radius: 5px;
        }
        
        .stat-label {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.7);
        }
        
        .stat-value {
            font-weight: bold;
            color: var(--primary);
        }
        
        .info-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--light);
        }
        
        .form-group input {
            width: 100%;
            padding: 0.8rem;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 5px;
            color: var(--light);
        }
        
        .form-group input:disabled {
            background-color: rgba(255, 255, 255, 0.02);
            border-color: rgba(255, 255, 255, 0.1);
        }
        
        .btn {
            padding: 0.8rem 1.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 5px;
            color: var(--dark);
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
        }
        
        .error {
            color: var(--danger);
            margin-bottom: 1rem;
            padding: 0.5rem;
            background-color: rgba(255, 56, 96, 0.1);
            border-radius: 5px;
        }
        
        .success {
            color: var(--success);
            margin-bottom: 1rem;
            padding: 0.5rem;
            background-color: rgba(0, 209, 178, 0.1);
            border-radius: 5px;
        }
        
        .tabs {
            display: flex;
            margin-bottom: 1.5rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .tab {
            padding: 0.8rem 1.5rem;
            cursor: pointer;
            border-bottom: 3px solid transparent;
            transition: all 0.3s ease;
        }
        
        .tab.active {
            border-bottom-color: var(--primary);
            color: var(--primary);
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .wallet-info {
            background-color: rgba(0, 184, 255, 0.1);
            padding: 1rem;
            border-radius: 5px;
            margin-top: 1rem;
            word-break: break-all;
        }
        
        .wallet-label {
            color: var(--secondary);
            margin-bottom: 0.5rem;
        }







        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: rgba(10, 10, 10, 0.8);
            border-right: 1px solid rgba(0, 255, 157, 0.1);
            padding: 1.5rem;
            position: fixed;
            height: 100vh;
            z-index: 100;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .logo h2 {
            font-size: 1.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .nav-menu {
            list-style: none;
        }
        
        .nav-item {
            margin-bottom: 0.5rem;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.8rem 1rem;
            color: var(--light);
            text-decoration: none;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover, .nav-link.active {
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .nav-link i {
            margin-right: 0.8rem;
            font-size: 1.2rem;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 2rem;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(0, 255, 157, 0.1);
            margin-right: 1rem;
            overflow: hidden;
        }
        
        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 56, 96, 0.2);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 255, 157, 0.1);
            border-color: rgba(0, 255, 157, 0.3);
        }
        
        .stat-title {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 0.5rem;
        }
        
        .stat-value {
            font-size: 1.8rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
        }
        
        .stat-desc {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.5);
        }
        
        .card-primary {
            border-top: 3px solid var(--primary);
        }
        
        .card-secondary {
            border-top: 3px solid var(--secondary);
        }
        
        .card-success {
            border-top: 3px solid var(--success);
        }
        
        .card-warning {
            border-top: 3px solid var(--warning);
        }
        
        .recent-activity {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            margin-top: 2rem;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        .activity-list {
            list-style: none;
        }
        
        .activity-item {
            padding: 1rem 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            display: flex;
            align-items: center;
        }
        
        .activity-item:last-child {
            border-bottom: none;
        }
        
        .activity-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(0, 255, 157, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            color: var(--primary);
        }
        
        .activity-content {
            flex: 1;
        }
        
        .activity-title {
            font-size: 0.9rem;
            margin-bottom: 0.2rem;
        }
        
        .activity-desc {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.6);
        }
        
        .activity-time {
            font-size: 0.7rem;
            color: rgba(255, 255, 255, 0.4);
        }
        
        /* Efectos futuristas */
        .glow-effect {
            position: relative;
            overflow: hidden;
        }
        
        .glow-effect::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0.3)
            );
            transform: rotate(30deg);
            animation: glow 6s linear infinite;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .glow-effect:hover::before {
            opacity: 0.3;
        }
        
        @keyframes glow {
            0% {
                transform: rotate(30deg) translate(-10%, -10%);
            }
            100% {
                transform: rotate(30deg) translate(10%, 10%);
            }
        }
        
        .no-activity {
            text-align: center;
            padding: 1rem;
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.9rem;
        }






        
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="sidebar">
        <div class="logo">
            <h2>JC Investment</h2>
        </div>
        
        <ul class="nav-menu">
            <li class="nav-item">
                <a href="dashboard.php" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="perfil.php" class="nav-link active">
                    <i class="fas fa-user"></i>
                    <span>Perfil</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="planes.php" class="nav-link">
                    <i class="fas fa-chart-line"></i>
                    <span>Planes</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="transferencia.php" class="nav-link">
                    <i class="fas fa-exchange-alt"></i>
                    <span>Transferencia</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="historial.php" class="nav-link">
                    <i class="fas fa-history"></i>
                    <span>Historial</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="deposito.php" class="nav-link">
                    <i class="fas fa-wallet"></i>
                    <span>Depósito</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="retiro.php" class="nav-link">
                    <i class="fas fa-money-bill-wave"></i>
                    <span>Retiro</span>
                </a>
            </li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="header">
            <div class="user-info">
                <div class="user-avatar">
                    <img src="<?php echo isset($user['foto_perfil']) ? $user['foto_perfil'] : 'default.png'; ?>" alt="Foto de perfil">
                </div>
                <div class="user-name"><?php echo htmlspecialchars($user['nombre_completo']); ?></div>
            </div>
            <button class="logout-btn" onclick="window.location.href='logout.php'">
                <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
            </button>
        </div>
        
        <?php if ($error): ?>
            <div class="error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <div class="profile-container">
            <div class="profile-card">
                <div class="profile-avatar">
                    <img src="<?php echo isset($user['foto_perfil']) ? $user['foto_perfil'] : 'default.png'; ?>" alt="Foto de perfil">
                    <label for="foto_perfil" class="profile-avatar-edit">
                        <i class="fas fa-camera"></i> Cambiar
                    </label>
                </div>
                
                <h3 class="profile-name"><?php echo htmlspecialchars($user['nombre_completo']); ?></h3>
                <div class="profile-email"><?php echo htmlspecialchars($user['correo']); ?></div>
                
                <div class="profile-stats">
                    <div class="stat-item">
                        <div class="stat-label">Miembro desde</div>
                        <div class="stat-value"><?php echo date('d M Y', strtotime($user['fecha_registro'])); ?></div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Teléfono</div>
                        <div class="stat-value"><?php echo htmlspecialchars($user['telefono']); ?></div>
                    </div>
                </div>
            </div>
            
            <div class="info-card">
                <div class="tabs">
                    <div class="tab active" data-tab="profile">Información del Perfil</div>
                    <div class="tab" data-tab="password">Cambiar Contraseña</div>
                </div>
                
                <div id="profile" class="tab-content active">
                    <form action="perfil.php" method="POST" enctype="multipart/form-data">
                        <input type="file" id="foto_perfil" name="foto_perfil" accept="image/*" style="display: none;">
                        
                        <div class="form-group">
                            <label for="nombre_completo">Nombre Completo</label>
                            <input type="text" id="nombre_completo" value="<?php echo htmlspecialchars($user['nombre_completo']); ?>" disabled>
                        </div>
                        
                        <div class="form-group">
                            <label for="correo">Correo Electrónico</label>
                            <input type="email" id="correo" value="<?php echo htmlspecialchars($user['correo']); ?>" disabled>
                        </div>
                        
                        <div class="form-group">
                            <label for="telefono">Número de WhatsApp</label>
                            <input type="tel" id="telefono" name="telefono" value="<?php echo htmlspecialchars($user['telefono']); ?>" required>
                        </div>
                        
                        <div class="wallet-info">
                            <div class="wallet-label">Wallet USDT (BEP20)</div>
                            <div><?php echo htmlspecialchars($user['wallet_usdt']); ?></div>
                            <small>Esta es la dirección donde recibirás tus retiros</small>
                        </div>
                        
                        <button type="submit" name="actualizar_perfil" class="btn">Guardar Cambios</button>
                    </form>
                </div>
                
                <div id="password" class="tab-content">
                    <form action="perfil.php" method="POST">
                        <div class="form-group">
                            <label for="current_password">Contraseña Actual</label>
                            <input type="password" id="current_password" name="current_password" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="new_password">Nueva Contraseña</label>
                            <input type="password" id="new_password" name="new_password" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="confirm_password">Confirmar Nueva Contraseña</label>
                            <input type="password" id="confirm_password" name="confirm_password" required>
                        </div>
                        
                        <button type="submit" name="cambiar_password" class="btn">Cambiar Contraseña</button>
                    </form>
                </div>
                
                <?php if ($es_referidor): ?>
                <div class="referidos-section">
                    <h3><i class="fas fa-user-friends"></i> Programa de Referidos</h3>
                    
                    <div class="referidos-stats">
                        <div class="referido-stat">
                            <div class="referido-stat-value"><?php echo $total_referidos; ?></div>
                            <div class="referido-stat-label">Total Referidos</div>
                        </div>
                        <div class="referido-stat">
                            <div class="referido-stat-value">$<?php echo number_format($total_comisiones, 2); ?></div>
                            <div class="referido-stat-label">Total Comisiones</div>
                        </div>
                    </div>
                    
                    <div class="referido-link-container">
                        <p>Tu enlace de referido:</p>
                        <div class="referido-link-input">
                            <input type="text" id="referido-link" value="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . '/registro.php?ref=' . $user['codigo_referido']; ?>" readonly>
                            <button onclick="copiarEnlaceReferido()"><i class="fas fa-copy"></i> Copiar</button>
                        </div>
                        <p class="referido-link-desc">
                            Gana el 10% de cada depósito que realicen tus referidos. Comparte este enlace para invitar a otros.
                        </p>
                    </div>
                    
                    <?php
                    // Obtener lista de referidos
                    $stmt = $conn->prepare("SELECT u.nombre_completo, r.monto_deposito, r.comision, r.fecha 
                                          FROM referidos r 
                                          JOIN usuarios u ON r.usuario_referido_id = u.id 
                                          WHERE r.usuario_referidor_id = ? 
                                          ORDER BY r.fecha DESC");
                    $stmt->execute([$user_id]);
                    $referidos = $stmt->fetchAll();
                    
                    if (!empty($referidos)): ?>
                        <div class="referidos-list">
                            <h4>Tus Referidos</h4>
                            <table class="referidos-table">
                                <thead>
                                    <tr>
                                        <th>Referido</th>
                                        <th>Depósito</th>
                                        <th>Comisión</th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($referidos as $referido): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($referido['nombre_completo']); ?></td>
                                            <td class="referido-amount">$<?php echo number_format($referido['monto_deposito'], 2); ?></td>
                                            <td class="referido-comision">$<?php echo number_format($referido['comision'], 2); ?></td>
                                            <td><?php echo date('d/m/Y', strtotime($referido['fecha'])); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p style="text-align: center; color: rgba(255, 255, 255, 0.5);">Aún no tienes referidos</p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        // Cambiar pestañas
        document.querySelectorAll('.tab').forEach(tab => {
            tab.addEventListener('click', function() {
                // Remover clase active de todas las pestañas y contenidos
                document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
                
                // Agregar clase active a la pestaña clickeada
                this.classList.add('active');
                
                // Mostrar el contenido correspondiente
                const tabId = this.getAttribute('data-tab');
                document.getElementById(tabId).classList.add('active');
            });
        });
        
        // Cambiar imagen al seleccionar archivo
        document.getElementById('foto_perfil').addEventListener('change', function(e) {
            if (this.files && this.files[0]) {
                const reader = new FileReader();
                const avatar = document.querySelector('.profile-avatar img');
                
                reader.onload = function(e) {
                    avatar.src = e.target.result;
                }
                
                reader.readAsDataURL(this.files[0]);
            }
        });
        
        // Simular click en input file al hacer click en el avatar
        document.querySelector('.profile-avatar-edit').addEventListener('click', function() {
            document.getElementById('foto_perfil').click();
        });
        
        // Copiar enlace de referido
        function copiarEnlaceReferido() {
            const enlace = document.getElementById('referido-link');
            enlace.select();
            document.execCommand('copy');
            
            // Mostrar notificación
            const originalText = event.target.innerHTML;
            event.target.innerHTML = '<i class="fas fa-check"></i> Copiado';
            setTimeout(() => {
                event.target.innerHTML = originalText;
            }, 2000);
        }
    </script>
</body>
</html>