<?php
session_start();
include 'connect.php';

// Establecer zona horaria correcta
date_default_timezone_set('UTC');

// Verificar si el usuario está logueado en este panel específico
if (!isset($_SESSION['planesganacia_logged_in'])) {
    // Mostrar formulario de login solo para el correo específico
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login'])) {
        $correo = trim($_POST['correo']);
        $password = trim($_POST['password']);
        
        // Validar que el correo sea el específico
        if ($correo === 'joelchaconvicente@gmail.com') {
            $stmt = $conn->prepare("SELECT id, password FROM usuarios WHERE correo = ?");
            $stmt->execute([$correo]);
            $user = $stmt->fetch();
            
            if ($user && password_verify($password, $user['password'])) {
                $_SESSION['planesganacia_logged_in'] = true;
                $_SESSION['planesganacia_user_id'] = $user['id'];
                header('Location: planesganacia.php');
                exit();
            } else {
                $login_error = "Credenciales incorrectas. Solo el administrador puede acceder a este panel.";
            }
        } else {
            $login_error = "Acceso denegado. Solo el administrador puede acceder a este panel.";
        }
    }
    
    // Mostrar formulario de login
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>JC Investment - Panel de Planes Ganancia</title>
        <style>
            :root {
                --primary: #00ff9d;
                --secondary: #00b8ff;
                --dark: #121212;
                --darker: #0a0a0a;
                --light: #f0f0f0;
                --danger: #ff3860;
                --success: #00d1b2;
            }
            
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
            
            body {
                background-color: var(--dark);
                color: var(--light);
                display: flex;
                justify-content: center;
                align-items: center;
                min-height: 100vh;
                padding: 2rem;
            }
            
            .login-container {
                background-color: rgba(10, 10, 10, 0.9);
                border: 1px solid rgba(0, 255, 157, 0.2);
                border-radius: 10px;
                padding: 2rem;
                width: 100%;
                max-width: 400px;
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
            }
            
            .logo {
                text-align: center;
                margin-bottom: 2rem;
            }
            
            .logo h2 {
                font-size: 1.8rem;
                background: linear-gradient(90deg, var(--primary), var(--secondary));
                -webkit-background-clip: text;
                background-clip: text;
                color: transparent;
                text-transform: uppercase;
                letter-spacing: 2px;
            }
            
            .form-group {
                margin-bottom: 1.5rem;
            }
            
            .form-group label {
                display: block;
                margin-bottom: 0.5rem;
                color: var(--light);
                font-size: 0.9rem;
            }
            
            .form-group input {
                width: 100%;
                padding: 0.8rem 1rem;
                background-color: rgba(255, 255, 255, 0.05);
                border: 1px solid rgba(0, 255, 157, 0.3);
                border-radius: 5px;
                color: var(--light);
                font-size: 1rem;
                transition: all 0.3s ease;
            }
            
            .form-group input:focus {
                outline: none;
                border-color: var(--primary);
                box-shadow: 0 0 0 3px rgba(0, 255, 157, 0.1);
            }
            
            .btn {
                width: 100%;
                padding: 0.8rem;
                background: linear-gradient(90deg, var(--primary), var(--secondary));
                border: none;
                border-radius: 5px;
                color: var(--dark);
                font-weight: bold;
                font-size: 1rem;
                cursor: pointer;
                transition: all 0.3s ease;
            }
            
            .btn:hover {
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
            }
            
            .error {
                color: var(--danger);
                margin-bottom: 1.5rem;
                padding: 0.8rem;
                background-color: rgba(255, 56, 96, 0.1);
                border-radius: 5px;
                border-left: 3px solid var(--danger);
                font-size: 0.9rem;
            }
            
            .login-footer {
                margin-top: 1.5rem;
                text-align: center;
                font-size: 0.8rem;
                color: rgba(255, 255, 255, 0.6);
            }
        </style>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    </head>
    <body>
        <div class="login-container">
            <div class="logo">
                <h2>JC Investment</h2>
                <p>Panel de Planes Ganancia</p>
            </div>
            
            <?php if (isset($login_error)): ?>
                <div class="error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $login_error; ?>
                </div>
            <?php endif; ?>
            
            <form action="planesganacia.php" method="POST">
                <div class="form-group">
                    <label for="correo">Correo Electrónico</label>
                    <input type="email" id="correo" name="correo" required>
                </div>
                
                <div class="form-group">
                    <label for="password">Contraseña</label>
                    <input type="password" id="password" name="password" required>
                </div>
                
                <button type="submit" name="login" class="btn">Iniciar Sesión</button>
            </form>
            
            <div class="login-footer">
                <p>Acceso restringido al administrador</p>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}

// Si llegamos aquí, el usuario está autenticado en el panel
$user_id = $_SESSION['planesganacia_user_id'];

// Crear la tabla planes_ganancia si no existe
try {
    $conn->exec("
    CREATE TABLE IF NOT EXISTS planes_ganancia (
        id INT AUTO_INCREMENT PRIMARY KEY,
        plan_origen_id INT NOT NULL,
        usuario_id INT NOT NULL,
        monto_inicial DECIMAL(15, 2) NOT NULL,
        monto_actual DECIMAL(15, 2) NOT NULL,
        ganancia_acumulada DECIMAL(15, 2) DEFAULT 0.00,
        fecha_inicio DATETIME DEFAULT CURRENT_TIMESTAMP,
        ultima_ganancia DATETIME DEFAULT CURRENT_TIMESTAMP,
        fecha_ultima_actualizacion DATETIME DEFAULT CURRENT_TIMESTAMP,
        completado BOOLEAN DEFAULT FALSE,
        FOREIGN KEY (plan_origen_id) REFERENCES planes(id) ON DELETE CASCADE,
        FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
    );
    ");

    // Agregar columna transferido_a_ganancia a la tabla planes si no existe
    $conn->exec("
    ALTER TABLE planes 
    ADD COLUMN IF NOT EXISTS transferido_a_ganancia BOOLEAN DEFAULT FALSE
    ");
} catch (PDOException $e) {
    // Manejar el error si es necesario
}

// Función para transferir planes completados a nuevos planes de ganancia
function transferirPlanesCompletados($conn) {
    // Obtener planes completados que aún no han sido transferidos
    $stmt = $conn->prepare("SELECT * FROM planes WHERE completado = TRUE AND transferido_a_ganancia = FALSE");
    $stmt->execute();
    $planes_completados = $stmt->fetchAll();
    
    foreach ($planes_completados as $plan) {
        // Crear nuevo plan con el monto inicial del plan completado
        $fecha_actual = gmdate('Y-m-d H:i:s');
        $stmt = $conn->prepare("INSERT INTO planes_ganancia (
            plan_origen_id, 
            usuario_id, 
            monto_inicial, 
            monto_actual, 
            fecha_inicio,
            ultima_ganancia
        ) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $plan['id'],
            $plan['usuario_id'],
            $plan['monto_inicial'],
            $plan['monto_inicial'],
            $fecha_actual,
            $fecha_actual
        ]);
        
        // Marcar el plan original como transferido
        $stmt = $conn->prepare("UPDATE planes SET transferido_a_ganancia = TRUE WHERE id = ?");
        $stmt->execute([$plan['id']]);
    }
}

// Función para calcular ganancias de los planes de ganancia
function calcularGananciasPlanesGanancia($conn) {
    // Obtener todos los planes de ganancia activos
    $stmt = $conn->prepare("SELECT * FROM planes_ganancia WHERE completado = FALSE");
    $stmt->execute();
    $planes = $stmt->fetchAll();
    
    foreach ($planes as $plan) {
        $ultima_ganancia = strtotime($plan['ultima_ganancia']);
        $ahora = time();
        $diferencia = $ahora - $ultima_ganancia;
        
        // Calcular cuántos ciclos de 24 horas han pasado
        $ciclos_completos = floor($diferencia / (24 * 3600));
        
        if ($ciclos_completos > 0) {
            // Calcular ganancia por cada ciclo completo (1% diario)
            $ganancia = $plan['monto_actual'] * 0.01 * $ciclos_completos;
            
            // Actualizar el plan
            $nueva_fecha = date('Y-m-d H:i:s', $ultima_ganancia + ($ciclos_completos * 24 * 3600));
            $nuevo_monto = $plan['monto_actual'] + $ganancia;
            
            $stmt = $conn->prepare("UPDATE planes_ganancia SET 
                monto_actual = ?,
                ganancia_acumulada = ganancia_acumulada + ?,
                ultima_ganancia = ?,
                fecha_ultima_actualizacion = UTC_TIMESTAMP()
                WHERE id = ?");
            $stmt->execute([$nuevo_monto, $ganancia, $nueva_fecha, $plan['id']]);
        }
    }
}

// Procesar acciones
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['transferir'])) {
        transferirPlanesCompletados($conn);
        $success = "Planes completados transferidos exitosamente a planes de ganancia.";
    } elseif (isset($_POST['calcular'])) {
        calcularGananciasPlanesGanancia($conn);
        $success = "Ganancias calculadas y aplicadas a los planes de ganancia.";
    } elseif (isset($_POST['logout'])) {
        session_destroy();
        header('Location: planesganacia.php');
        exit();
    }
}

// Ejecutar funciones automáticamente al cargar la página
transferirPlanesCompletados($conn);
calcularGananciasPlanesGanancia($conn);

// Obtener planes completados recientemente
$stmt = $conn->prepare("SELECT p.*, u.nombre_completo 
    FROM planes p 
    JOIN usuarios u ON p.usuario_id = u.id 
    WHERE p.completado = TRUE 
    ORDER BY p.fecha_ultima_actualizacion DESC 
    LIMIT 10");
$stmt->execute();
$planes_completados = $stmt->fetchAll();

// Obtener planes de ganancia activos
$stmt = $conn->prepare("SELECT pg.*, u.nombre_completo, p.monto_inicial as monto_plan_original
    FROM planes_ganancia pg
    JOIN planes p ON pg.plan_origen_id = p.id
    JOIN usuarios u ON pg.usuario_id = u.id
    WHERE pg.completado = FALSE
    ORDER BY pg.fecha_inicio DESC");
$stmt->execute();
$planes_ganancia = $stmt->fetchAll();

// Obtener planes de ganancia completados
$stmt = $conn->prepare("SELECT pg.*, u.nombre_completo, p.monto_inicial as monto_plan_original
    FROM planes_ganancia pg
    JOIN planes p ON pg.plan_origen_id = p.id
    JOIN usuarios u ON pg.usuario_id = u.id
    WHERE pg.completado = TRUE
    ORDER BY pg.fecha_inicio DESC
    LIMIT 10");
$stmt->execute();
$planes_ganancia_completados = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JC Investment - Panel de Planes Ganancia</title>
    <style>
        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .logo {
            font-size: 1.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 56, 96, 0.2);
        }
        
        .section-title {
            font-size: 1.2rem;
            margin: 2rem 0 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        .actions {
            display: flex;
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .btn {
            padding: 0.8rem 1.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 5px;
            color: var(--dark);
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
        }
        
        .btn-secondary {
            background: var(--secondary);
        }
        
        .error {
            color: var(--danger);
            margin-bottom: 1rem;
            padding: 0.8rem;
            background-color: rgba(255, 56, 96, 0.1);
            border-radius: 5px;
            border-left: 3px solid var(--danger);
        }
        
        .success {
            color: var(--success);
            margin-bottom: 1rem;
            padding: 0.8rem;
            background-color: rgba(0, 209, 178, 0.1);
            border-radius: 5px;
            border-left: 3px solid var(--success);
        }
        
        .card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .card-title {
            font-weight: bold;
            color: var(--primary);
        }
        
        .card-date {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.5);
        }
        
        .card-body {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 1rem;
        }
        
        .detail-item {
            background-color: rgba(0, 255, 157, 0.1);
            padding: 0.8rem;
            border-radius: 5px;
        }
        
        .detail-label {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 0.3rem;
        }
        
        .detail-value {
            font-weight: bold;
            font-size: 1rem;
        }
        
        .table-container {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 2rem;
        }
        
        th, td {
            padding: 0.8rem 1rem;
            text-align: left;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        th {
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
            font-weight: bold;
        }
        
        tr:hover {
            background-color: rgba(0, 255, 157, 0.05);
        }
        
        .badge {
            display: inline-block;
            padding: 0.3rem 0.6rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: bold;
        }
        
        .badge-success {
            background-color: rgba(0, 209, 178, 0.1);
            color: var(--success);
        }
        
        .badge-warning {
            background-color: rgba(255, 221, 87, 0.1);
            color: var(--warning);
        }
        
        .badge-primary {
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .progress-container {
            width: 100%;
            height: 8px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 4px;
            margin: 0.5rem 0;
            overflow: hidden;
        }
        
        .progress-bar {
            height: 100%;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border-radius: 4px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            position: relative;
            overflow: hidden;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
        }
        
        .stat-title {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 0.5rem;
        }
        
        .stat-value {
            font-size: 1.5rem;
            font-weight: bold;
            color: var(--primary);
            margin-bottom: 0.5rem;
        }
        
        .stat-description {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.5);
        }
        
        @media (max-width: 768px) {
            .container {
                padding: 1rem;
            }
            
            .header {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            
            .actions {
                flex-direction: column;
            }
            
            .card-body {
                grid-template-columns: 1fr;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">JC Investment - Panel de Planes Ganancia</div>
            <div class="user-info">
                <span>Administrador</span>
                <form action="planesganacia.php" method="POST">
                    <button type="submit" name="logout" class="logout-btn">
                        <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
                    </button>
                </form>
            </div>
        </div>
        
        <?php if (isset($success)): ?>
            <div class="success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <div class="actions">
            <form action="planesganacia.php" method="POST">
                <button type="submit" name="transferir" class="btn">
                    <i class="fas fa-exchange-alt"></i> Transferir Planes Completados
                </button>
            </form>
            <form action="planesganacia.php" method="POST">
                <button type="submit" name="calcular" class="btn btn-secondary">
                    <i class="fas fa-calculator"></i> Calcular Ganancias
                </button>
            </form>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-title">Planes Completados</div>
                <div class="stat-value"><?php echo count($planes_completados); ?></div>
                <div class="stat-description">Planes listos para transferir</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-title">Planes Ganancia Activos</div>
                <div class="stat-value"><?php echo count($planes_ganancia); ?></div>
                <div class="stat-description">Generando ganancias del 1% diario</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-title">Capital Total</div>
                <div class="stat-value">$<?php 
                    $total = 0;
                    foreach ($planes_ganancia as $plan) {
                        $total += $plan['monto_actual'];
                    }
                    echo number_format($total, 2); 
                ?></div>
                <div class="stat-description">Capital en planes de ganancia</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-title">Ganancias Diarias</div>
                <div class="stat-value">$<?php 
                    $ganancias_diarias = 0;
                    foreach ($planes_ganancia as $plan) {
                        $ganancias_diarias += $plan['monto_actual'] * 0.01;
                    }
                    echo number_format($ganancias_diarias, 2); 
                ?></div>
                <div class="stat-description">Generadas por los planes activos</div>
            </div>
        </div>
        
        <h3 class="section-title">
            <i class="fas fa-spinner"></i> Planes Ganancia Activos
        </h3>
        
        <?php if (empty($planes_ganancia)): ?>
            <div class="card">
                <p>No hay planes de ganancia activos actualmente.</p>
            </div>
        <?php else: ?>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Usuario</th>
                            <th>Plan Origen</th>
                            <th>Capital</th>
                            <th>Ganancias</th>
                            <th>Inicio</th>
                            <th>Última Ganancia</th>
                            <th>Próxima Ganancia</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($planes_ganancia as $plan): 
                            $proxima_ganancia = strtotime($plan['ultima_ganancia']) + (24 * 3600);
                            $tiempo_restante = $proxima_ganancia - time();
                            $horas_restantes = floor($tiempo_restante / 3600);
                            $minutos_restantes = floor(($tiempo_restante % 3600) / 60);
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($plan['nombre_completo']); ?></td>
                                <td>$<?php echo number_format($plan['monto_plan_original'], 2); ?></td>
                                <td>$<?php echo number_format($plan['monto_actual'], 2); ?></td>
                                <td>$<?php echo number_format($plan['ganancia_acumulada'], 2); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($plan['fecha_inicio'])); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($plan['ultima_ganancia'])); ?></td>
                                <td>
                                    <?php if ($tiempo_restante > 0): ?>
                                        <span class="badge badge-warning">
                                            <?php echo $horas_restantes > 0 ? $horas_restantes . 'h ' : ''; ?>
                                            <?php echo $minutos_restantes . 'm'; ?>
                                        </span>
                                    <?php else: ?>
                                        <span class="badge badge-success">Listo</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
        
        <h3 class="section-title">
            <i class="fas fa-check-circle"></i> Planes Completados Recientes
        </h3>
        
        <?php if (empty($planes_completados)): ?>
            <div class="card">
                <p>No hay planes completados recientemente.</p>
            </div>
        <?php else: ?>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Usuario</th>
                            <th>Monto Inicial</th>
                            <th>Ganancias</th>
                            <th>Inicio</th>
                            <th>Finalización</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($planes_completados as $plan): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($plan['nombre_completo']); ?></td>
                                <td>$<?php echo number_format($plan['monto_inicial'], 2); ?></td>
                                <td>$<?php echo number_format($plan['monto_inicial'] * 2, 2); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($plan['fecha_inicio'])); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($plan['fecha_ultima_actualizacion'])); ?></td>
                                <td>
                                    <?php if ($plan['transferido_a_ganancia']): ?>
                                        <span class="badge badge-success">Transferido</span>
                                    <?php else: ?>
                                        <span class="badge badge-warning">Pendiente</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
        
        <h3 class="section-title">
            <i class="fas fa-history"></i> Planes Ganancia Completados
        </h3>
        
        <?php if (empty($planes_ganancia_completados)): ?>
            <div class="card">
                <p>No hay planes de ganancia completados.</p>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="card-body">
                    <?php foreach ($planes_ganancia_completados as $plan): ?>
                        <div class="detail-item">
                            <div class="detail-label">Usuario</div>
                            <div class="detail-value"><?php echo htmlspecialchars($plan['nombre_completo']); ?></div>
                            
                            <div class="detail-label">Plan Origen</div>
                            <div class="detail-value">$<?php echo number_format($plan['monto_plan_original'], 2); ?></div>
                            
                            <div class="detail-label">Capital Final</div>
                            <div class="detail-value">$<?php echo number_format($plan['monto_actual'], 2); ?></div>
                            
                            <div class="detail-label">Ganancias Generadas</div>
                            <div class="detail-value">$<?php echo number_format($plan['ganancia_acumulada'], 2); ?></div>
                            
                            <div class="detail-label">Duración</div>
                            <div class="detail-value">
                                <?php 
                                    $inicio = new DateTime($plan['fecha_inicio']);
                                    $fin = new DateTime($plan['fecha_ultima_actualizacion']);
                                    $intervalo = $inicio->diff($fin);
                                    echo $intervalo->format('%a días');
                                ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>