-- Tabla de referidos
CREATE TABLE referidos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_referidor_id INT NOT NULL,
    usuario_referido_id INT NOT NULL,
    monto_deposito DECIMAL(15, 2) NOT NULL,
    comision DECIMAL(15, 2) NOT NULL,
    fecha DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_referidor_id) REFERENCES usuarios(id) ON DELETE CASCADE,
    FOREIGN KEY (usuario_referido_id) REFERENCES usuarios(id) ON DELETE CASCADE
);

-- Agregar campo de código de referido a la tabla usuarios
ALTER TABLE usuarios ADD COLUMN codigo_referido VARCHAR(20) DEFAULT NULL;
ALTER TABLE usuarios ADD COLUMN referido_por INT DEFAULT NULL;
ALTER TABLE usuarios ADD CONSTRAINT fk_referido_por FOREIGN KEY (referido_por) REFERENCES usuarios(id) ON DELETE SET NULL;

-- Asignar código de referido al usuario específico
UPDATE usuarios SET codigo_referido = 'JCVIP' WHERE correo = 'joelchaconvicente@gmail.com';