<?php
include 'connect.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre_completo = trim($_POST['nombre_completo']);
    $correo = trim($_POST['correo']);
    $telefono = trim($_POST['telefono']);
    $wallet_usdt = trim($_POST['wallet_usdt']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $codigo_referido = trim($_POST['codigo_referido']);
    
    // Validaciones básicas
    if (empty($codigo_referido)) {
        $error = 'El código de referido es obligatorio';
    } elseif ($password !== $confirm_password) {
        $error = 'Las contraseñas no coinciden';
    } elseif (!filter_var($correo, FILTER_VALIDATE_EMAIL)) {
        $error = 'Correo electrónico no válido';
    } else {
        // Verificar si el correo ya existe
        $stmt = $conn->prepare("SELECT id FROM usuarios WHERE correo = ?");
        $stmt->execute([$correo]);
        
        if ($stmt->rowCount() > 0) {
            $error = 'El correo electrónico ya está registrado';
        } else {
            // Verificar que el código de referido pertenezca al usuario específico
            $stmt = $conn->prepare("SELECT id FROM usuarios WHERE codigo_referido = ? AND correo = 'joelchaconvicente@gmail.com'");
            $stmt->execute([$codigo_referido]);
            
            if ($stmt->rowCount() == 0) {
                $error = 'Código de referido no válido. Solo el administrador puede registrar nuevos usuarios.';
            } else {
                $referidor = $stmt->fetch();
                $referido_por = $referidor['id'];
                
                // Hash de la contraseña
                $hashed_password = password_hash($password, PASSWORD_BCRYPT);
                
                // Insertar nuevo usuario
                $stmt = $conn->prepare("INSERT INTO usuarios (nombre_completo, correo, telefono, wallet_usdt, password, referido_por) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([$nombre_completo, $correo, $telefono, $wallet_usdt, $hashed_password, $referido_por]);
                
                $success = 'Registro exitoso. Ahora puedes iniciar sesión.';
                
                // Redirigir al login después de 3 segundos
                header("refresh:3;url=login.php");
            }
        }
    }
}

// Obtener código de referido de la URL si existe
$ref_code = isset($_GET['ref']) ? $_GET['ref'] : '';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JC Investment - Registro</title>
    <style>
        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-image: 
                radial-gradient(circle at 10% 20%, rgba(0, 255, 157, 0.1) 0%, transparent 20%),
                radial-gradient(circle at 90% 80%, rgba(0, 184, 255, 0.1) 0%, transparent 20%);
        }
        
        .register-container {
            background-color: rgba(18, 18, 18, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.2);
            border-radius: 10px;
            padding: 2rem;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 0 20px rgba(0, 255, 157, 0.1),
                        0 0 40px rgba(0, 184, 255, 0.1);
            backdrop-filter: blur(10px);
            animation: glow 3s infinite alternate;
        }
        
        @keyframes glow {
            0% {
                box-shadow: 0 0 20px rgba(0, 255, 157, 0.1),
                            0 0 40px rgba(0, 184, 255, 0.1);
            }
            100% {
                box-shadow: 0 0 30px rgba(0, 255, 157, 0.2),
                            0 0 50px rgba(0, 184, 255, 0.2);
            }
        }
        
        .logo {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .logo h1 {
            font-size: 2rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--light);
            font-size: 0.9rem;
        }
        
        .form-group input {
            width: 100%;
            padding: 0.8rem;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 5px;
            color: var(--light);
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px rgba(0, 255, 157, 0.2);
        }
        
        .btn {
            width: 100%;
            padding: 0.8rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 5px;
            color: var(--dark);
            font-size: 1rem;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
        }
        
        .error {
            color: var(--danger);
            text-align: center;
            margin-bottom: 1rem;
            font-size: 0.9rem;
            padding: 0.8rem;
            background-color: rgba(255, 56, 96, 0.1);
            border-radius: 5px;
        }
        
        .success {
            color: var(--success);
            text-align: center;
            margin-bottom: 1rem;
            font-size: 0.9rem;
            padding: 0.8rem;
            background-color: rgba(0, 209, 178, 0.1);
            border-radius: 5px;
        }
        
        .login-link {
            text-align: center;
            margin-top: 1.5rem;
            font-size: 0.9rem;
        }
        
        .login-link a {
            color: var(--secondary);
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .login-link a:hover {
            color: var(--primary);
            text-decoration: underline;
        }
        
        .referido-section {
            margin-bottom: 1.5rem;
            padding: 1rem;
            background-color: rgba(0, 184, 255, 0.1);
            border-radius: 5px;
            text-align: center;
        }
        
        .referido-section p {
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }
        
        .referido-section input {
            text-align: center;
            font-weight: bold;
        }
        
        .particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            overflow: hidden;
        }
        
        .particle {
            position: absolute;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border-radius: 50%;
            opacity: 0.5;
            animation: float linear infinite;
        }
        
        @keyframes float {
            0% {
                transform: translateY(0) translateX(0);
            }
            50% {
                transform: translateY(-100px) translateX(100px);
            }
            100% {
                transform: translateY(0) translateX(0);
            }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="particles" id="particles"></div>
    
    <div class="register-container">
        <div class="logo">
            <h1>JC Investment</h1>
        </div>
        
        <?php if ($error): ?>
            <div class="error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <form action="registro.php" method="POST">
            <div class="form-group">
                <label for="nombre_completo">Nombre Completo</label>
                <input type="text" id="nombre_completo" name="nombre_completo" required>
            </div>
            
            <div class="form-group">
                <label for="correo">Correo Electrónico</label>
                <input type="email" id="correo" name="correo" required>
            </div>
            
            <div class="form-group">
                <label for="telefono">Número de WhatsApp</label>
                <input type="tel" id="telefono" name="telefono" required>
            </div>
            
            <div class="form-group">
                <label for="wallet_usdt">Wallet USDT (BEP20)</label>
                <input type="text" id="wallet_usdt" name="wallet_usdt" required>
            </div>
            
            <div class="form-group">
                <label for="password">Contraseña</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <div class="form-group">
                <label for="confirm_password">Confirmar Contraseña</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
            </div>
            
            <?php if (!empty($ref_code)): ?>
                <div class="referido-section">
                    <p><i class="fas fa-user-friends"></i> Código de Referido (obligatorio)</p>
                    <input type="text" name="codigo_referido" value="<?php echo htmlspecialchars($ref_code); ?>" required>
                </div>
            <?php else: ?>
                <div class="form-group">
                    <label for="codigo_referido">Código de Referido <span style="color: var(--danger);">*</span></label>
                    <input type="text" id="codigo_referido" name="codigo_referido" required>
                    <small style="display: block; margin-top: 0.5rem; color: rgba(255, 255, 255, 0.6);">
                        Debes obtener un código válido del administrador para registrarte.
                    </small>
                </div>
            <?php endif; ?>
            
            <button type="submit" class="btn">
                <i class="fas fa-user-plus"></i> Registrarse
            </button>
        </form>
        
        <div class="login-link">
            ¿Ya tienes una cuenta? <a href="login.php"><i class="fas fa-sign-in-alt"></i> Inicia sesión aquí</a>
        </div>
    </div>

    <script>
        // Efecto de partículas
        const particlesContainer = document.getElementById('particles');
        const particleCount = 20;
        
        for (let i = 0; i < particleCount; i++) {
            const particle = document.createElement('div');
            particle.classList.add('particle');
            
            const size = Math.random() * 5 + 2;
            const posX = Math.random() * 100;
            const posY = Math.random() * 100;
            const duration = Math.random() * 20 + 10;
            const delay = Math.random() * 5;
            
            particle.style.width = `${size}px`;
            particle.style.height = `${size}px`;
            particle.style.left = `${posX}%`;
            particle.style.top = `${posY}%`;
            particle.style.animationDuration = `${duration}s`;
            particle.style.animationDelay = `${delay}s`;
            
            particlesContainer.appendChild(particle);
        }
        
        // Mostrar/ocultar código de referido si viene en la URL
        document.addEventListener('DOMContentLoaded', function() {
            const urlParams = new URLSearchParams(window.location.search);
            const refCode = urlParams.get('ref');
            
            if (refCode) {
                document.getElementById('codigo_referido').value = refCode;
            }
        });
    </script>
</body>
</html>