<?php
include 'connect.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT nombre_completo, foto_perfil, saldo_planes, wallet_usdt FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

$error = '';
$success = '';

// Procesar retiro
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $monto = floatval($_POST['monto']);
    
    if ($monto < 10) {
        $error = 'El monto mínimo de retiro es $10 USDT';
    } elseif ($monto > $user['saldo_planes']) {
        $error = 'Saldo insuficiente en tu cuenta de Planes';
    } else {
        // Registrar retiro
        $stmt = $conn->prepare("INSERT INTO retiros (usuario_id, monto, estado) VALUES (?, ?, 'pendiente')");
        $stmt->execute([$user_id, $monto]);
        
        // Actualizar saldo de planes
        $nuevo_saldo = $user['saldo_planes'] - $monto;
        $stmt = $conn->prepare("UPDATE usuarios SET saldo_planes = ? WHERE id = ?");
        $stmt->execute([$nuevo_saldo, $user_id]);
        
        $success = 'Retiro solicitado correctamente. Será procesado en las próximas 24 horas.';
        $user['saldo_planes'] = $nuevo_saldo;
    }
}

// Obtener historial de retiros
$stmt = $conn->prepare("SELECT * FROM retiros WHERE usuario_id = ? ORDER BY fecha DESC LIMIT 10");
$stmt->execute([$user_id]);
$historial_retiros = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JC Investment - Retiro</title>
    <style>
        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: rgba(10, 10, 10, 0.8);
            border-right: 1px solid rgba(0, 255, 157, 0.1);
            padding: 1.5rem;
            position: fixed;
            height: 100vh;
            z-index: 100;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 2rem;
        }
        
        /* Estilos reutilizados del dashboard */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        /* Estilos específicos de retiro */
        .withdraw-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 2rem;
        }
        
        .withdraw-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
        }
        
        .withdraw-card h3 {
            margin-bottom: 1rem;
            color: var(--primary);
        }
        
        .balance-info {
            background-color: rgba(0, 255, 157, 0.1);
            padding: 1rem;
            border-radius: 5px;
            margin-bottom: 1.5rem;
            text-align: center;
        }
        
        .balance-label {
            color: rgba(255, 255, 255, 0.7);
        }
        
        .balance-amount {
            font-size: 1.5rem;
            font-weight: bold;
            color: var(--primary);
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--light);
        }
        
        .form-group input {
            width: 100%;
            padding: 0.8rem;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 5px;
            color: var(--light);
        }
        
        .btn {
            width: 100%;
            padding: 0.8rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 5px;
            color: var(--dark);
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
        }
        
        .error {
            color: var(--danger);
            margin-bottom: 1rem;
            padding: 0.5rem;
            background-color: rgba(255, 56, 96, 0.1);
            border-radius: 5px;
        }
        
        .success {
            color: var(--success);
            margin-bottom: 1rem;
            padding: 0.5rem;
            background-color: rgba(0, 209, 178, 0.1);
            border-radius: 5px;
        }
        
        .wallet-info {
            background-color: rgba(0, 184, 255, 0.1);
            padding: 1rem;
            border-radius: 5px;
            margin-bottom: 1.5rem;
            word-break: break-all;
        }
        
        .wallet-label {
            color: var(--secondary);
            margin-bottom: 0.5rem;
        }
        
        .history-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }
        
        .history-table th {
            text-align: left;
            padding: 1rem;
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .history-table td {
            padding: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .status {
            display: inline-block;
            padding: 0.3rem 0.6rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: bold;
        }
        
        .status-pendiente {
            background-color: rgba(255, 221, 87, 0.1);
            color: var(--warning);
        }
        
        .status-completado {
            background-color: rgba(0, 209, 178, 0.1);
            color: var(--success);
        }
        
        .status-rechazado {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
        }
        
        .amount {
            font-weight: bold;
            color: var(--danger);
        }






        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: rgba(10, 10, 10, 0.8);
            border-right: 1px solid rgba(0, 255, 157, 0.1);
            padding: 1.5rem;
            position: fixed;
            height: 100vh;
            z-index: 100;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .logo h2 {
            font-size: 1.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .nav-menu {
            list-style: none;
        }
        
        .nav-item {
            margin-bottom: 0.5rem;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.8rem 1rem;
            color: var(--light);
            text-decoration: none;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover, .nav-link.active {
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .nav-link i {
            margin-right: 0.8rem;
            font-size: 1.2rem;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 2rem;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(0, 255, 157, 0.1);
            margin-right: 1rem;
            overflow: hidden;
        }
        
        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 56, 96, 0.2);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 255, 157, 0.1);
            border-color: rgba(0, 255, 157, 0.3);
        }
        
        .stat-title {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 0.5rem;
        }
        
        .stat-value {
            font-size: 1.8rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
        }
        
        .stat-desc {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.5);
        }
        
        .card-primary {
            border-top: 3px solid var(--primary);
        }
        
        .card-secondary {
            border-top: 3px solid var(--secondary);
        }
        
        .card-success {
            border-top: 3px solid var(--success);
        }
        
        .card-warning {
            border-top: 3px solid var(--warning);
        }
        
        .recent-activity {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            margin-top: 2rem;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        .activity-list {
            list-style: none;
        }
        
        .activity-item {
            padding: 1rem 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            display: flex;
            align-items: center;
        }
        
        .activity-item:last-child {
            border-bottom: none;
        }
        
        .activity-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(0, 255, 157, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            color: var(--primary);
        }
        
        .activity-content {
            flex: 1;
        }
        
        .activity-title {
            font-size: 0.9rem;
            margin-bottom: 0.2rem;
        }
        
        .activity-desc {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.6);
        }
        
        .activity-time {
            font-size: 0.7rem;
            color: rgba(255, 255, 255, 0.4);
        }
        
        /* Efectos futuristas */
        .glow-effect {
            position: relative;
            overflow: hidden;
        }
        
        .glow-effect::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0.3)
            );
            transform: rotate(30deg);
            animation: glow 6s linear infinite;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .glow-effect:hover::before {
            opacity: 0.3;
        }
        
        @keyframes glow {
            0% {
                transform: rotate(30deg) translate(-10%, -10%);
            }
            100% {
                transform: rotate(30deg) translate(10%, 10%);
            }
        }
        
        .no-activity {
            text-align: center;
            padding: 1rem;
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.9rem;
        }















    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="sidebar">
        <div class="logo">
            <h2>JC Investment</h2>
        </div>
        
        <ul class="nav-menu">
            <li class="nav-item">
                <a href="dashboard.php" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="perfil.php" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Perfil</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="planes.php" class="nav-link">
                    <i class="fas fa-chart-line"></i>
                    <span>Planes</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="transferencia.php" class="nav-link">
                    <i class="fas fa-exchange-alt"></i>
                    <span>Transferencia</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="historial.php" class="nav-link">
                    <i class="fas fa-history"></i>
                    <span>Historial</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="deposito.php" class="nav-link">
                    <i class="fas fa-wallet"></i>
                    <span>Depósito</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="retiro.php" class="nav-link active">
                    <i class="fas fa-money-bill-wave"></i>
                    <span>Retiro</span>
                </a>
            </li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="header">
            <div class="user-info">
                <div class="user-avatar">
                    <img src="<?php echo isset($user['foto_perfil']) ? $user['foto_perfil'] : 'default.png'; ?>" alt="Foto de perfil">
                </div>
                <div class="user-name"><?php echo htmlspecialchars($user['nombre_completo']); ?></div>
            </div>
            <button class="logout-btn" onclick="window.location.href='logout.php'">
                <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
            </button>
        </div>
        
        <?php if ($error): ?>
            <div class="error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <div class="withdraw-container">
            <div class="withdraw-card">
                <h3><i class="fas fa-money-bill-wave"></i> Solicitar Retiro</h3>
                
                <div class="balance-info">
                    <div class="balance-label">Saldo disponible en Planes</div>
                    <div class="balance-amount">$<?php echo number_format($user['saldo_planes'], 2); ?> USDT</div>
                </div>
                
                <div class="wallet-info">
                    <div class="wallet-label">Wallet de retiro (USDT BEP20)</div>
                    <div><?php echo htmlspecialchars($user['wallet_usdt']); ?></div>
                    <small>Los fondos serán enviados a esta dirección</small>
                </div>
                
                <form action="retiro.php" method="POST">
                    <div class="form-group">
                        <label for="monto">Monto a retirar (USDT)</label>
                        <input type="number" id="monto" name="monto" min="10" max="<?php echo $user['saldo_planes']; ?>" step="0.01" required>
                        <small>Mínimo: $10.00 USDT</small>
                    </div>
                    
                    <button type="submit" class="btn">Solicitar Retiro</button>
                </form>
            </div>
            
            <div class="withdraw-card">
                <h3><i class="fas fa-history"></i> Historial de Retiros</h3>
                
                <table class="history-table">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Monto</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($historial_retiros)): ?>
                            <tr>
                                <td colspan="3" style="text-align: center; padding: 2rem; color: rgba(255, 255, 255, 0.5);">
                                    No hay retiros registrados
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($historial_retiros as $retiro): ?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($retiro['fecha'])); ?></td>
                                    <td class="amount">-$<?php echo number_format($retiro['monto'], 2); ?></td>
                                    <td>
                                        <span class="status status-<?php echo $retiro['estado']; ?>">
                                            <?php echo ucfirst($retiro['estado']); ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>