<?php
include 'connect.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

$error = '';
$success = '';

// Procesar transferencia
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $monto = floatval($_POST['monto']);
    $tipo = $_POST['tipo'];
    
    if ($monto <= 0) {
        $error = 'El monto debe ser mayor a cero';
    } else {
        if ($tipo == 'deposito_a_inversion') {
            if ($monto <= $user['saldo_deposito']) {
                // Transferir de depósito a inversión
                $nuevo_saldo_deposito = $user['saldo_deposito'] - $monto;
                $nuevo_saldo_inversion = $user['saldo_inversion'] + $monto;
                
                $conn->beginTransaction();
                
                try {
                    $stmt = $conn->prepare("UPDATE usuarios SET saldo_deposito = ?, saldo_inversion = ? WHERE id = ?");
                    $stmt->execute([$nuevo_saldo_deposito, $nuevo_saldo_inversion, $user_id]);
                    
                    $stmt = $conn->prepare("INSERT INTO transferencias (usuario_id, monto, tipo) VALUES (?, ?, ?)");
                    $stmt->execute([$user_id, $monto, $tipo]);
                    
                    $conn->commit();
                    $success = 'Transferencia realizada correctamente';
                    
                    // Actualizar datos del usuario
                    $user['saldo_deposito'] = $nuevo_saldo_deposito;
                    $user['saldo_inversion'] = $nuevo_saldo_inversion;
                } catch (Exception $e) {
                    $conn->rollBack();
                    $error = 'Error al realizar la transferencia';
                }
            } else {
                $error = 'Saldo insuficiente en Depósito';
            }
        } elseif ($tipo == 'inversion_a_deposito') {
            if ($monto <= $user['saldo_inversion']) {
                // Transferir de inversión a depósito
                $nuevo_saldo_inversion = $user['saldo_inversion'] - $monto;
                $nuevo_saldo_deposito = $user['saldo_deposito'] + $monto;
                
                $conn->beginTransaction();
                
                try {
                    $stmt = $conn->prepare("UPDATE usuarios SET saldo_inversion = ?, saldo_deposito = ? WHERE id = ?");
                    $stmt->execute([$nuevo_saldo_inversion, $nuevo_saldo_deposito, $user_id]);
                    
                    $stmt = $conn->prepare("INSERT INTO transferencias (usuario_id, monto, tipo) VALUES (?, ?, ?)");
                    $stmt->execute([$user_id, $monto, $tipo]);
                    
                    $conn->commit();
                    $success = 'Transferencia realizada correctamente';
                    
                    // Actualizar datos del usuario
                    $user['saldo_inversion'] = $nuevo_saldo_inversion;
                    $user['saldo_deposito'] = $nuevo_saldo_deposito;
                } catch (Exception $e) {
                    $conn->rollBack();
                    $error = 'Error al realizar la transferencia';
                }
            } else {
                $error = 'Saldo insuficiente en Inversión';
            }
        } elseif ($tipo == 'planes_a_inversion') {
            if ($monto <= $user['saldo_planes']) {
                // Transferir de planes a inversión
                $nuevo_saldo_planes = $user['saldo_planes'] - $monto;
                $nuevo_saldo_inversion = $user['saldo_inversion'] + $monto;
                
                $conn->beginTransaction();
                
                try {
                    $stmt = $conn->prepare("UPDATE usuarios SET saldo_planes = ?, saldo_inversion = ? WHERE id = ?");
                    $stmt->execute([$nuevo_saldo_planes, $nuevo_saldo_inversion, $user_id]);
                    
                    $stmt = $conn->prepare("INSERT INTO transferencias (usuario_id, monto, tipo) VALUES (?, ?, ?)");
                    $stmt->execute([$user_id, $monto, $tipo]);
                    
                    $conn->commit();
                    $success = 'Transferencia realizada correctamente';
                    
                    // Actualizar datos del usuario
                    $user['saldo_planes'] = $nuevo_saldo_planes;
                    $user['saldo_inversion'] = $nuevo_saldo_inversion;
                } catch (Exception $e) {
                    $conn->rollBack();
                    $error = 'Error al realizar la transferencia';
                }
            } else {
                $error = 'Saldo insuficiente en Planes';
            }
        } elseif ($tipo == 'deposito_a_planes') {
            if ($monto <= $user['saldo_deposito']) {
                // Transferir de depósito a planes
                $nuevo_saldo_deposito = $user['saldo_deposito'] - $monto;
                $nuevo_saldo_planes = $user['saldo_planes'] + $monto;
                
                $conn->beginTransaction();
                
                try {
                    $stmt = $conn->prepare("UPDATE usuarios SET saldo_deposito = ?, saldo_planes = ? WHERE id = ?");
                    $stmt->execute([$nuevo_saldo_deposito, $nuevo_saldo_planes, $user_id]);
                    
                    $stmt = $conn->prepare("INSERT INTO transferencias (usuario_id, monto, tipo) VALUES (?, ?, ?)");
                    $stmt->execute([$user_id, $monto, $tipo]);
                    
                    $conn->commit();
                    $success = 'Transferencia realizada correctamente';
                    
                    // Actualizar datos del usuario
                    $user['saldo_deposito'] = $nuevo_saldo_deposito;
                    $user['saldo_planes'] = $nuevo_saldo_planes;
                } catch (Exception $e) {
                    $conn->rollBack();
                    $error = 'Error al realizar la transferencia';
                }
            } else {
                $error = 'Saldo insuficiente en Depósito';
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JC Investment - Transferencia</title>
    <style>
        :root {
            --primary: #00ff9d;
            --secondary: #00b8ff;
            --dark: #121212;
            --darker: #0a0a0a;
            --light: #f0f0f0;
            --danger: #ff3860;
            --success: #00d1b2;
            --warning: #ffdd57;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: var(--dark);
            color: var(--light);
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: rgba(10, 10, 10, 0.8);
            border-right: 1px solid rgba(0, 255, 157, 0.1);
            padding: 1.5rem;
            position: fixed;
            height: 100vh;
            z-index: 100;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .logo h2 {
            font-size: 1.5rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .nav-menu {
            list-style: none;
        }
        
        .nav-item {
            margin-bottom: 0.5rem;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.8rem 1rem;
            color: var(--light);
            text-decoration: none;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover, .nav-link.active {
            background-color: rgba(0, 255, 157, 0.1);
            color: var(--primary);
        }
        
        .nav-link i {
            margin-right: 0.8rem;
            font-size: 1.2rem;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 2rem;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(0, 255, 157, 0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(0, 255, 157, 0.1);
            margin-right: 1rem;
            overflow: hidden;
        }
        
        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .user-name {
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .logout-btn {
            background-color: rgba(255, 56, 96, 0.1);
            color: var(--danger);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 56, 96, 0.2);
        }
        
        .transfer-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
        }
        
        .transfer-card {
            background-color: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(0, 255, 157, 0.1);
            border-radius: 10px;
            padding: 1.5rem;
            transition: all 0.3s ease;
        }
        
        .transfer-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 255, 157, 0.1);
            border-color: rgba(0, 255, 157, 0.3);
        }
        
        .transfer-card h3 {
            margin-bottom: 1rem;
            color: var(--primary);
            text-align: center;
        }
        
        .balance-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 1rem;
            padding: 1rem;
            background-color: rgba(0, 255, 157, 0.1);
            border-radius: 5px;
        }
        
        .balance-label {
            color: rgba(255, 255, 255, 0.7);
        }
        
        .balance-amount {
            font-weight: bold;
            color: var(--primary);
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--light);
        }
        
        .form-group input, .form-group select {
            width: 100%;
            padding: 0.8rem;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(0, 255, 157, 0.3);
            border-radius: 5px;
            color: var(--light);
        }
        
        .btn {
            width: 100%;
            padding: 0.8rem;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 5px;
            color: var(--dark);
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 157, 0.3);
        }
        
        .error {
            color: var(--danger);
            margin-bottom: 1rem;
            padding: 0.5rem;
            background-color: rgba(255, 56, 96, 0.1);
            border-radius: 5px;
        }
        
        .success {
            color: var(--success);
            margin-bottom: 1rem;
            padding: 0.5rem;
            background-color: rgba(0, 209, 178, 0.1);
            border-radius: 5px;
        }
        
        .section-title {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 0.5rem;
        }
        
        /* Efectos futuristas */
        .glow-effect {
            position: relative;
            overflow: hidden;
        }
        
        .glow-effect::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0),
                rgba(0, 255, 157, 0.3)
            );
            transform: rotate(30deg);
            animation: glow 6s linear infinite;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .glow-effect:hover::before {
            opacity: 0.3;
        }
        
        @keyframes glow {
            0% {
                transform: rotate(30deg) translate(-10%, -10%);
            }
            100% {
                transform: rotate(30deg) translate(10%, 10%);
            }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="sidebar">
        <div class="logo">
            <h2>JC Investment</h2>
        </div>
        
        <ul class="nav-menu">
            <li class="nav-item">
                <a href="dashboard.php" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="perfil.php" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Perfil</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="planes.php" class="nav-link">
                    <i class="fas fa-chart-line"></i>
                    <span>Planes</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="transferencia.php" class="nav-link active">
                    <i class="fas fa-exchange-alt"></i>
                    <span>Transferencia</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="historial.php" class="nav-link">
                    <i class="fas fa-history"></i>
                    <span>Historial</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="deposito.php" class="nav-link">
                    <i class="fas fa-wallet"></i>
                    <span>Depósito</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="retiro.php" class="nav-link">
                    <i class="fas fa-money-bill-wave"></i>
                    <span>Retiro</span>
                </a>
            </li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="header">
            <div class="user-info">
                <div class="user-avatar">
                    <img src="<?php echo isset($user['foto_perfil']) ? $user['foto_perfil'] : 'default.png'; ?>" alt="Foto de perfil">
                </div>
                <div class="user-name"><?php echo htmlspecialchars($user['nombre_completo']); ?></div>
            </div>
            <button class="logout-btn" onclick="window.location.href='logout.php'">
                <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
            </button>
        </div>
        
        <?php if ($error): ?>
            <div class="error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <h2 class="section-title">
            <i class="fas fa-exchange-alt"></i> Transferencia Interna
        </h2>
        
        <div class="transfer-container">
            <div class="transfer-card">
                <h3>De Depósito a Inversión</h3>
                
                <div class="balance-info">
                    <span class="balance-label">Saldo en Depósito:</span>
                    <span class="balance-amount">$<?php echo number_format($user['saldo_deposito'], 2); ?></span>
                </div>
                
                <form action="transferencia.php" method="POST">
                    <input type="hidden" name="tipo" value="deposito_a_inversion">
                    
                    <div class="form-group">
                        <label for="monto_deposito">Monto a transferir (USDT)</label>
                        <input type="number" id="monto_deposito" name="monto" min="0.01" max="<?php echo $user['saldo_deposito']; ?>" step="0.01" required>
                    </div>
                    
                    <button type="submit" class="btn">Transferir</button>
                </form>
            </div>
            
            <div class="transfer-card">
                <h3>De Depósito a Planes</h3>
                
                <div class="balance-info">
                    <span class="balance-label">Saldo en Depósito:</span>
                    <span class="balance-amount">$<?php echo number_format($user['saldo_deposito'], 2); ?></span>
                </div>
                
                <form action="transferencia.php" method="POST">
                    <input type="hidden" name="tipo" value="deposito_a_planes">
                    
                    <div class="form-group">
                        <label for="monto_deposito_planes">Monto a transferir (USDT)</label>
                        <input type="number" id="monto_deposito_planes" name="monto" min="0.01" max="<?php echo $user['saldo_deposito']; ?>" step="0.01" required>
                    </div>
                    
                    <button type="submit" class="btn">Transferir</button>
                </form>
            </div>
            
            <div class="transfer-card">
                <h3>De Planes a Inversión</h3>
                
                <div class="balance-info">
                    <span class="balance-label">Saldo en Planes:</span>
                    <span class="balance-amount">$<?php echo number_format($user['saldo_planes'], 2); ?></span>
                </div>
                
                <form action="transferencia.php" method="POST">
                    <input type="hidden" name="tipo" value="planes_a_inversion">
                    
                    <div class="form-group">
                        <label for="monto_planes">Monto a transferir (USDT)</label>
                        <input type="number" id="monto_planes" name="monto" min="0.01" max="<?php echo $user['saldo_planes']; ?>" step="0.01" required>
                    </div>
                    
                    <button type="submit" class="btn">Transferir</button>
                </form>
            </div>
            
            <div class="transfer-card">
                <h3>De Inversión a Depósito</h3>
                
                <div class="balance-info">
                    <span class="balance-label">Saldo en Inversión:</span>
                    <span class="balance-amount">$<?php echo number_format($user['saldo_inversion'], 2); ?></span>
                </div>
                
                <form action="transferencia.php" method="POST">
                    <input type="hidden" name="tipo" value="inversion_a_deposito">
                    
                    <div class="form-group">
                        <label for="monto_inversion">Monto a transferir (USDT)</label>
                        <input type="number" id="monto_inversion" name="monto" min="0.01" max="<?php echo $user['saldo_inversion']; ?>" step="0.01" required>
                    </div>
                    
                    <button type="submit" class="btn">Transferir</button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>